#' Calculate weight of building damage compared to some other damage
#' 
#' @param x, named list of damaging functions
#' @param what, character, names of element of x that will be used
#' @return array of weight
#' 
#' @keywords internal

calculate_weight_building = function(x, what) {
	b = grep(sprintf("%s_building", what), names(x))
	r = sprintf("weight_%s_building", what)
	total  = apply(x[grep(what, names(x))], 1, sum)
	x[[r]] = x[[b]] / total
	x[[r]][total == 0] = 0
	return(x)
}
