#' Adjust model information in the table opening
#' 
#' @param data_table list of table informations of the model.
#' @param file_log path of the file where to write log information.
#' @return the opening table adjusted
#' 
#' @keywords internal

adjust_opening_03 = function(data_table, file_log) {

	if (is.null(data_table[["opening"]])) return(NULL)
	
	# Adding parameter information
	result = keep_df_order(data_table[["opening"]], merge, data_table[["parameter"]][["opening"]], all.x = TRUE, by = "type", suffixes = c("_x","_y"))

	# Adjusting H_abs
	data_table[["wall"]][["height_wall"]] = data_table[["wall"]][["height"]]
	result = keep_df_order(result, merge, data_table[["wall"]][c("building", "storey", "storey", "room", "wall", "H_abs", "height_wall")], suffixes = c("_x","_y"))
	selection = grep("^H$|^H_abs$", names(result))
	result[["H_abs"]] = apply(result[selection], 1, sum, na.rm = TRUE)

	# Checking height
	selection = (result[["height"]] + result[["H"]]) > result[["height_wall"]]
	if (any(is.na(selection))) {
		msg = paste("\n\t- ", 
			apply(result[is.na(selection), c("room", "wall", "type")], 1, paste, collapse = "/"), 
			sep = "", collapse = "")
		stop(sprintf("Problems encountered when processing openings (maybe a typo?): %s", msg))
	}
	if (any(selection)) {
		temp = split(result[selection,], droplevels(result[selection,][["type"]]))
		x = lapply(temp, function(x){apply(x[c("storey", "room", "wall")], 1, paste, collapse = " / ")})
		report = c("\nSome openings are too high...", unlist(mapply(update_report, x, names(temp))))
		write(report, file = file_log, append = TRUE)
		warning(sprintf("Some openings are too high... Look at %s for details", file_log))
	}
	result[["height_wall"]] = NULL

	# Checking positions of openings
	temp = split(result, result[c("type", "x", "y", "H_abs")], drop = TRUE)
	selection_1 = sapply(temp, nrow) != 2 # Shoudl have exactly 2 occurrence of the same opening
	selection_2 = sapply(temp, function(x){length(unique(x[["room"]])) != 2}) # Same opening should be a link between two different rooms
	selection = selection_1 | selection_2
	
	if (any(selection)) {
		x = lapply(temp[selection], function(x){apply(x[c("storey", "room", "wall", "type", "x", "y", "H_abs")], 1, paste, collapse = " / ")})
		report = c(
			"\nProblems encountered when processing openings.\nPlease check whether the following opening is correctly declared\nin the elements list and whether the assigned positions are correct: ", 
			unlist(mapply(update_report, x, ""))
		)
		write(report, file = file_log, append = TRUE)
		warning(sprintf("Problems encountered when processing openings... Look at %s for details", file_log))
	}

	# Making surface
	result[["surface"]] = result[["height"]] * result[["width"]] / 10000
	
	# Making elementary_component
	result[["opening_elementary_component"]] = compose_elementary_component(result[["opening_type"]], result[["material"]])
	result[["shutter_elementary_component"]] = compose_elementary_component(result[["opening_type"]], result[["shutter"]], what = "shutter")
	
	invisible(result)
}
	

adjust_opening_02 = function(data_table, file_log)
{
	if (is.null(data_table[["opening"]])) {
		return(NULL)
	}

	# Adjusting H_abs
	data_table[["wall"]][["height_wall"]] = data_table[["wall"]][["height"]]
	result = keep_df_order(
		data_table[["opening"]],
		merge,
		data_table[["wall"]][c("storey", "room", "wall", "id_wall", "H_abs", "height_wall")],
		suffixes = c("_x","_y")
	)
	selection = grep("^H$|^H_abs$", names(result))
	result[["H_abs"]] = apply(result[selection], 1, sum, na.rm = TRUE)

	# Checking height
	selection = (result[["height"]] + result[["H"]]) > result[["height_wall"]]
	if (any(is.na(selection))) {
		msg = paste("\n\t- ", 
			apply(result[is.na(selection), c("room", "wall", "type")], 1, paste, collapse = "/"), 
			sep = "", collapse = "")
		stop(sprintf("Problems encountered when processing openings (maybe a typo?): %s", msg))
	}
	if (any(selection)) {
		temp = split(result[selection,], droplevels(result[selection,][["type"]]))
		x = lapply(temp, function(x){apply(x[c("storey", "room", "wall")], 1, paste, collapse = " / ")})
		report = c("\nSome openings are too high...", unlist(mapply(update_report, x, names(temp))))
		write(
			report,
			file = file_log,
			append = TRUE
		)
		warning(
			sprintf(
				"Some openings are too high... Look at %s for details",
				file_log
			)
		)
	}
	result[["height_wall"]] = NULL

	# Checking positions of openings
	temp = split(result, result[c("type", "x", "y", "H_abs")], drop = TRUE)
	selection_1 = sapply(temp, nrow) != 2 # Shoudl have exactly 2 occurrence of the same opening
	selection_2 = sapply(temp, function(x){length(unique(x[["room"]])) != 2}) # Same opening should be a link between two different rooms
	selection = selection_1 | selection_2
	
	if (any(selection)) {
		x = lapply(temp[selection], function(x){apply(x[c("storey", "room", "wall", "type", "x", "y", "H_abs")], 1, paste, collapse = " / ")})
		report = c(
			"\nProblems encountered when processing openings.\nPlease check whether the following opening is correctly declared\nin the elements list and whether the assigned positions are correct: ", 
			unlist(mapply(update_report, x, ""))
		)
		write(
			report,
			file = file_log,
			append = TRUE
		)
		warning(
			sprintf(
				"Problems encountered when processing openings... Look at %s for details",
				file_log
			)
		)
	}

	# Making surface
	result[["surface"]] = result[["height"]] * result[["width"]] / 10000
	
	# Making elementary_component
	result[["opening_elementary_component"]] = compose_elementary_component(result[["opening_type"]], result[["material"]])
	result[["shutter_elementary_component"]] = compose_elementary_component(result[["opening_type"]], result[["shutter"]], what = "shutter")
	
	invisible(result)
}
	
