test_that("Test to_numeric",
    {
        expect_equal(to_numeric("1.2"), 1.2)
        expect_equal(to_numeric("1.2,1.2"), c(1.2, 1.2))
        expect_equal(to_numeric("1.2, 1.2,"), c(1.2, 1.2))
        expect_equal(to_numeric("1.2, 1.2,,"), c(1.2, 1.2, NA))
        expect_equal(to_numeric("1.2;1.2"), "1.2;1.2")
        expect_equal(to_numeric("1.2;1.2", sep = ";"), c(1.2, 1.2))
        expect_equal(to_numeric("1,2;1,2", sep = ";"), c("1,2", "1,2"))
        expect_equal(to_numeric("1,2;1,2", sep = ";", dec = ","), c(1.2, 1.2))

        xml = list(
            a = "1.2",
            b = list("1.2,1.2", "1.2, 1.2,", "1.2, 1.2,,"),
            c = list(a = "1.2;1.2")
        )
        result = list(
            a = 1.2,
            b = list(c(1.2, 1.2), c(1.2, 1.2), c(1.2, 1.2, NA)),
            c = list(a = "1.2;1.2")
        )
        expect_equal(
            rapply(xml, to_numeric, how = "replace"),
            result
        )
    }
)