test_that("Test merge_rooms",
    {
        output_dir = tempdir()

        model = analyse_model(
            model = adu_t_invisible,
            stage = c("extract", "hydraulic"),
            verbose = FALSE
        )

        flood = expect_no_message(
            generate_limnigraph(
                model = model,
                time = c(0, 54, 108),
                depth = cbind(
                    facade = c(0, 1, 0)
                ),
                exposition = list(
                    facade = list(external = c(
                        "wall_A", "wall_B", "wall_C", "wall_D",
                        "wall_E", "wall_F", "wall_G", "wall_H"
                    ))
                ),
                verbose = FALSE
            )
        )

        out_hyd = analyse_hydraulic(
            model = model,
            limnigraph = flood,
            opening_scenario = "close",
            stage = c("hydraulic"),
            sim_id = "integrated_model",
            verbose = FALSE)
            
        expect_no_error(out_hyd$hmax)
        expect_identical(out_hyd[["hmax"]][, "room_3"], 
            out_hyd[["hmax"]][, "room_1"])
    }
)
