test_that("Test sumup_damaging",
    {
        expect_null(sumup_damaging(x = list(a = NULL, b = NULL)))

        result = sumup_damaging(
            x = list(
                a = NULL, 
                b = DAM[["load_bearing_wall_concrete"]]
            )
        )
        expect_s3_class(result,"damaging")

        expect_equal(
            sumup_damaging(
                x = list(
                    a = DAM[["load_bearing_wall_concrete"]], 
                    b = DAM[["load_bearing_wall_concrete"]]
                )
            ),
            2 * result
        )
    }
)

test_that("Test compute_damage_from_detail",
    {
        result = compute_damage_from_detail(
            x = list(
                room = NULL,
                wall = NULL,
                opening = NULL,
                coating = NULL,
                furniture = NULL
                ),
            category = "category_dwelling_01"
        )
        hazard_range = getOption("floodam_building_hazard_range")
        ref = array(0, dim = lengths(hazard_range), dimnames = hazard_range)
        expect_length(result, 2)
        expect_type(result, "list")
        expect_s3_class(result[[1]], "damaging")
        expect_equal(unclass(result[[1]]), ref)

        result = compute_damage_from_detail(
            x = list(
                room = DAM["load_bearing_wall_concrete"],
                wall = NULL,
                opening = NULL,
                coating = NULL,
                furniture = DAM["washing_machine"]
                ),
            category = "category_dwelling_01"
        )
        expect_length(result, 3)
        expect_type(result, "list")
        expect_s3_class(result[[1]], "damaging")
        
    }
)