test_that("Test compute_exchange", 
    {
        opening_name = c("door1", "door2", "door3", "door4", "window1", "window2", "window3")

        exchange = rbind(
            width = c(1.10, 0.90, 0.90, 0.90, 0.90, 0.90, 0.90),
            z_bottom = c(0.0, 0.0, 0.0, 0.0, 0.90, 0.90, 0.90),
            z_top = c(2.30, 2.05, 2.05, 2.05, 2.00, 2.00, 2.00), 
            Cd = 0.42,
            z_up = c(2.5, 2.1, 2.1, 0.5, 2.5, 2.5, 0.95),
            z_down = c(2.1, 1.0, 1.4, 2.1, 0.5, 1.0, 1.4),
            flow = 0,
            s = 0
        )

        result_R = expect_no_error(compute_exchange(exchange))
        result_Rcpp = (rcpp_compute_exchange(exchange))
        dimnames(result_Rcpp) = dimnames(result_R)
        expect_identical(result_R, result_Rcpp)

        colnames(exchange) = opening_name
        result_R = expect_no_error(compute_exchange(exchange))
        dimnames(result_Rcpp) = dimnames(result_R)
        expect_identical(result_R, result_Rcpp)
    }
)
