test_that("Test compute_damage_by_room_wall",
    {
        # testing with a single-storey model
        model = adu_t
        reference = model[["damaging"]][["absolute"]][["total"]]
        result = Reduce(
            "+", 
            lapply(
                names(model[["dam_room_wall"]][["absolute_room"]]), 
                function(x){
                    return(
                        model[["dam_room_wall"]][["absolute_room"]][[x]][["total"]]
                    )
                }
            )
        )
        expect_true(isTRUE(all.equal(result, reference)))

        expect_in(
            names(model[["dam_room_wall"]][["absolute_room"]]), 
            levels(model[["data_table"]][["room"]][["room"]])
        )

        model = adu_t_basement
        model = analyse_model(model, stage = c("extract", "damaging", "hydraulic"), verbose = FALSE)
        reference = model[["damaging"]][["absolute"]][["total"]]
        result = Reduce(
            "+", 
            lapply(
                names(model[["dam_room_wall"]][["absolute_room"]]), 
                function(x){
                    return(
                        model[["dam_room_wall"]][["absolute_room"]][[x]][["total"]]
                    )
                }
            )
        )
        expect_false(isTRUE(all.equal(result, reference)))
    }
)
