test_that("Test calculate_width", 
    {
        # Intermediary step
        data_table = expect_no_warning(
            extract_building_information(adu_t, verbose = FALSE)
        )

        # No specification of columns
        lazy = expect_no_error(calculate_wall_width_02(data_table[["wall"]]))

        # Strict specification of columbs (quicker)
        better = expect_no_error(
            calculate_wall_width_02(
                data_table[["wall"]][c("storey", "room", "x", "y")]
            )
        )

        # Should give the same result
        expect_identical(lazy, better)

        names(better) = NULL

        # Should be the same as what has been calculated for internal data
        expect_identical(
            adu_t[["data_table"]][["wall"]][["width"]],
            better
        )
    }
)
