//rcpp_compute_exchange.cpp
#include <Rcpp.h>
using namespace Rcpp;

//' rcpp_compute_exchange
//'
//' Compute surface and flow for a matrix of exchange
//'
//' @param exchange matrix giving need information
//'
//' @return matrix 
//'
//' @export
// [[Rcpp::export]]
NumericMatrix rcpp_compute_exchange(NumericMatrix exchange){

    NumericMatrix result( 2 , exchange.cols() );
    double z_up;
    double z_down;
    double flow;
    double s;
    double q;
	
    for (int o = 0; o < exchange.cols(); ++o) {

        if (exchange( 4 , o ) >= exchange( 5 , o )) {
            z_up = exchange( 4 , o );
            z_down = exchange( 5 , o );
            flow = 1;
        } else {
            z_up = exchange( 5 , o );
            z_down = exchange( 4 , o );
            flow = -1;
        }

        if ( z_up <= exchange( 1 , o ) ) {
            // water level lower to crest elevation → no flow
            s = 0;
            q = 0;
        } else {
            if ( z_up <= exchange( 2 , o ) ) {
                if ( z_down <= exchange( 1 , o )) {
                    // unsubmerged weir law
                    s = exchange( 0 , o ) * (z_up - exchange( 1 , o ));
                    q = exchange( 3 , o ) * sqrt(2 * 9.81) * s * sqrt(z_up - exchange( 1 , o ));
                } else {
                    // submerged weir law
                    s = exchange( 0 , o ) * ((z_up + z_down) / 2 - exchange( 1 , o ));
                    q = exchange( 3 , o ) * sqrt(2 * 9.81) * s * sqrt(z_up - z_down);                 
                }
            } else {
                if ( z_down <= exchange( 1 , o )) {
                    // unsubmerged gate law
                    s = exchange( 0 , o ) * (exchange( 2 , o ) - exchange( 1 , o ));
                    q = exchange( 3 , o ) * sqrt(2 * 9.81) * s * sqrt(z_up - (exchange( 2 , o ) + exchange( 1 , o )) / 2);
                } else {
                    // submerged gate law
                    s = exchange( 0 , o ) * (exchange( 2 , o ) - exchange( 1 , o ));
                    q = exchange( 3 , o ) * sqrt(2 * 9.81) * s * sqrt(z_up - z_down);                 
                } 
            }
        }

        result( 0, o ) = s;
        result( 1, o ) = flow * q;
    }

    return result;
}
