% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_type.R
\name{update_type}
\alias{update_type}
\title{Update models of a given type.}
\usage{
update_type(
  type,
  hazard_range = getOption("floodam_building_hazard_range"),
  path = getOption("floodam_building_path"),
  graph = getOption("floodam_building_graph"),
  verbose = getOption("floodam_building_verbose"),
  sel = NULL,
  skip = NULL
)
}
\arguments{
\item{type}{character, type of model that is loaded, default to NULL}

\item{hazard_range}{if damaging are calculated, gives the range for hazard, default to getOption("floodam_building_hazard_range")}

\item{path}{list of useful paths, default to getOption("floodam_building_path")}

\item{graph}{boolean, will graphs be plotted, default to getOption("floodam_building_graph")}

\item{verbose}{boolean, will floodam tells what it is doing, default to getOption("floodam_building_verbose")}

\item{sel}{character, models to be selected within type, default to NULL (everything is selected)}

\item{skip}{character, models not to be selected within types, default to NULL (nothing is skipped)}
}
\value{
a list of models
}
\description{
Update models of a given type.
}
\examples{
\dontrun{
update_type("activity")
}

}
