% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumup_damaging.R
\name{sumup_damaging}
\alias{sumup_damaging}
\title{Summarize detailed list of elementary damaging functions.}
\usage{
sumup_damaging(x, who = NULL)
}
\arguments{
\item{x, }{object of class elementary_damaging or a list}

\item{who, }{NULL or character to trace the name of the calling function if an error occurs}
}
\value{
an object of class "damaging"
}
\description{
Summarize detailed list of elementary damaging functions.
}
\examples{

	model = analyse_model(model = adu_t, stage = c("extract", "damaging"))
	damage = sumup_damaging(model[["damaging"]][["detail"]])


 model = analyse_model(adu_t_basement, stage = c("extract", "damaging"))
 selection = grepl(
 	"external",
 	levels(model[["data_table"]][["wall"]][["room"]])
 )
 
 external = split(
 	as.character(model[["data_table"]][["wall"]][["wall"]]), 
 	model[["data_table"]][["wall"]][["room"]]
 )[selection]
 
 detail_by_room = extract_damage_detail_by_room(
 	x = model[["damaging"]][["detail"]], 
 	room = levels(model[["data_table"]][["room"]][["room"]])
 )
 
 damage = sumup_damaging(detail_by_room[["external_basement"]])

}
