% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_model.R
\name{save_model}
\alias{save_model}
\title{Save a model}
\usage{
save_model(model, verbose = getOption("floodam_building_verbose"))
}
\arguments{
\item{model}{model}

\item{verbose}{logical, default to getOption("floodam_building_verbose")}
}
\value{
An object of class "model" with those characteristics
\describe{
\item{building}{list, representation of information stored in the building file}
\item{path}{list, useful paths to read and write data}
\item{file_name}{list, useful file names to read and write data}
}#
}
\description{
Save a model
}
\examples{

	model_path = list(
		data = system.file("extdata", package = "floodam.building"),
		output = tempdir()
	)
	model = analyse_model(
		model = "adu_t", 
		type = "adu", 
		stage = c("load", "extract", "damaging"), 
		path = model_path
	)
	save_model(model)

}
