% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_in_xml.R
\name{replace_in_building}
\alias{replace_in_building}
\title{Replace elements in some building part of a model}
\usage{
replace_in_building(l, element, type, value)
}
\arguments{
\item{l, }{list, corresponding to a subset of building part a model}

\item{element, }{character of length 1, where in the list should be found
what to change}

\item{type, }{character of length 2, giving correspondence between original
and final type with names c('origin', 'final')}

\item{value, }{named vector, giving correspondence between new values (values)
and old ones (names)}
}
\value{
a list of same structure than l with types ans values changed.
}
\description{
Replace elements in some building part of a model
}
\examples{
\dontrun{
	model_path = list(
		data = system.file("extdata", package = "floodam.building"),
		output = tempdir()
	)
	model = load_model(model = "adu_t", type = "adu", path = model_path)
	temp = replace_in_building(
	l = model[["building"]][["element"]],
   	element = "ceiling",
   	type = c("origin" = "ceiling_1", "final" = "ceiling_1"),
   	value = c(
   	    "concrete" = "concrete",
   	    "cellular_plastic" = "cellular_plastic",
   	    "paint" = "paint",
   	    "260" = "200"
	)
)
}

}
