% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep_df_order.R
\name{keep_df_order}
\alias{keep_df_order}
\title{Keep rows order in data.frame when a function is applied to it.}
\usage{
keep_df_order(df, fun, ...)
}
\arguments{
\item{df}{the data.frame that will be changed by the function fun}

\item{fun}{the function that will be applied}

\item{...}{other parameters to fun}
}
\description{
Keep rows order in data.frame when a function is applied to it.
}
\section{Source of inspiration}{

A comment from landroni (2017-09-23 at 15:59) on \url{http://stackoverflow.com}
}

\examples{

df_1 = data.frame(object = c('A', 'B', 'D', 'F', 'C'), class = c(2, 1, 2, 3, 1))
df_2 = data.frame(class = c(1, 2, 3), prob = c(0.5, 0.7, 0.3))
merge(df_1, df_2)
keep_df_order(df_1, merge, df_2, suffixes = c("_x","_y"))

}
