% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_value.R
\name{extract_value}
\alias{extract_value}
\title{Extract some values information of a model}
\usage{
extract_value(
  model,
  room = NULL,
  furniture = NULL,
  category = NULL,
  model_name = NULL,
  verbose = getOption("floodam_building_verbose")
)
}
\arguments{
\item{model}{an object of class model}

\item{room}{a data.frame describing room of a model, set to
\code{model[["data_table"]][["room"]]} if model is provided.}

\item{furniture}{a data.frame describing furniture of a model, set to
\code{model[["data_table"]][["furniture"]]} if model is provided.}

\item{category}{a character vector describing category of a model, set to
\code{model[["category"]]} if model is provided.}

\item{model_name}{a character scalar giving names of a model, set to
\code{model[["name"]]} if model is provided.}

\item{verbose}{logical, default to getOption("floodam_building_verbose")}
}
\value{
An list of value organized as follow
\describe{
\item{surface}{a data.frame with 'internal' and 'external' surfaces.
Surfaces are estimated at storey level, maximum is taken.}
\item{monetary}{a data frame with the estimation of total monetary value
replacement for elementary components classified  according to the 'category'
of the model}
}
}
\description{
Extract some values information of a model
}
\examples{
# Example 1

# analyzing model 'simple' of type 'simple' using the sequential steps *load* 
# (load model data) and *extract* (extract model data)
model = analyse_model(
     model = "adu_simple",
		type = "adu",
     path = init_create_path(
         input = system.file("extdata", package = "floodam.building"),
         output = tempdir()
     ),
     stage = c("load", "extract")
)
extract_value(model)

# Example 2

# using already loaded library model 'dwelling' 
model = adu_t

# extracting model data
model = analyse_model(model = model, stage = "extract")

extract_value(model)

}
