% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_hydraulic_input.R
\name{extract_hydraulic_input}
\alias{extract_hydraulic_input}
\title{Extract hydraulic input data from model}
\usage{
extract_hydraulic_input(
  model,
  initial_water_depth_interior =
    getOption("floodam_building_hydraulic_initial_water_depth_interior"),
  discharge_coefficient = getOption("floodam_building_hydraulic_discharge_coefficient"),
  close_opening_margin = getOption("floodam_building_hydraulic_close_opening_clearance"),
  verbose = getOption("floodam_building_verbose")
)
}
\arguments{
\item{model}{an object of class model}

\item{initial_water_depth_interior}{numeric, initial water depth in each room in meters, default to
getOption("floodam_building_hydraulic_initial_water_depth_interior")}

\item{discharge_coefficient}{numeric, discharge coefficient for each opening, default to
getOption("floodam_building_hydraulic_discharge_coefficient")}

\item{close_opening_margin}{numeric, measurement of the opening gap clearance, default to
getOption("floodam_building_hydraulic_close_opening_clearance")}

\item{verbose}{boolean, will floodam tells what it is doing, default to getOption("floodam_building_verbose")}
}
\value{
component hydraulic of the model
}
\description{
Extract hydraulic input data from model
}
