% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_damage_detail_by_room.R
\name{extract_damage_detail_external}
\alias{extract_damage_detail_external}
\title{Extract elementary components in external by wall}
\usage{
extract_damage_detail_external(x, wall)
}
\arguments{
\item{x}{list of elementary damaging corresponding to the external wall of
a given storey organized and named as given in the slot "detail" of the slot
"damaging" of a model}

\item{wall}{character, the names of the external walls in the storey}
}
\value{
a list of elementary components
}
\description{
\code{extract_damage_detail_external()} is an \strong{internal} function that
extracts elementary components in external by wall.
}
\details{
This function is meant to be called during the calculation of damage
functions
}
\examples{
 # example 1
 extract_damage_detail_external(
   x = adu_t[["damaging"]][["detail"]], 
   wall = "wall_A"
 )

 #example 2
 test = analyse_model(adu_t_basement, stage = c("extract", "damaging"))
 data_table = test$data_table
 result = test$damaging
	selection = grepl(
   "external",
   levels(data_table[["wall"]][["room"]])
 )

 external = split(
   as.character(data_table[["wall"]][["wall"]]), 
   data_table[["wall"]][["room"]]
 )[selection]

 detail_by_room = extract_damage_detail_by_room(
   x = result[["detail"]], 
   room = levels(data_table[["room"]][["room"]])
 )

 detail_by_external = sapply(
     names(external),
   function(ew) {
     extract_damage_detail_external(
       detail_by_room[[ew]], 
       wall = external[[ew]]
     )
   },
   simplify = FALSE
 )

}
\seealso{
\code{\link[=extract_damage_detail_by_room]{extract_damage_detail_by_room()}} and
\code{\link[=extract_elementary_component_from_detail]{extract_elementary_component_from_detail()}}, to handle the calculation of
damage functions by rooms and walls
}
