% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_new_model.R
\name{create_new_model}
\alias{create_new_model}
\title{creates a new model template}
\usage{
create_new_model(
  input_file,
  version_building = "02",
  type_building = "xml",
  file_path = tempdir(),
  editor = getOption("editor")
)
}
\arguments{
\item{input_file}{character,either "building", "furniture" or "metadata",
depending on the input file you wish to create}

\item{version_building}{character, version of building model to be used,
default to "02". Not necessary when input_file = "furniture"}

\item{type_building}{character, type of building file to create ("xml" or
"yaml"), default to xml. Not necessary when input_file = "furniture"}

\item{file_path}{character, path to folder where to store the input file,
default to tempdir()}

\item{editor}{character, the text editor to be used}
}
\value{
new editor window with building.xml template open
}
\description{
creates a new model template
}
\examples{
\dontrun{

create_new_model(input_file = "building")

create_new_model(input_file = "building", editor = "code")

create_new_model(input_file = "furniture", editor = "rstudio")

create_new_model(
   input_file = "building", 
   type_building = "yaml", 
   editor = "code"
)

create_new_model(input_file = "metadata", editor = "code")
}

}
