% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_hydraulic.R
\name{compute_hydraulic}
\alias{compute_hydraulic}
\title{Analyse the hydraulics of the model}
\usage{
compute_hydraulic(
  opening,
  room,
  bound,
  open,
  dt_max,
  t_start = 0,
  t_max,
  height_break = 1,
  r_names_to_merge = NULL,
  detail = TRUE
)
}
\arguments{
\item{opening}{data.frame, containing informations on the openings, coming
from the hydraulic part of the model}

\item{room}{data.frame, containing informations on the rooms, coming
from the hydraulic part of the model}

\item{bound}{numeric, matrix of floodwater depth heights by instant t
for each exterior opening exposed to flooding}

\item{open}{data.frame, containing informations on the openings in an \code{open}
scenario, coming from the hydraulic part of the model}

\item{dt_max}{numeric, optional; maximum timestep for simulation}

\item{t_start}{numeric, start time of the simulation}

\item{t_max}{numeric, duration of the flood event in seconds,
optional; if not provided, calculated using limnigraph}

\item{height_break}{numeric, the differential height on each side of an
opening needed to break it}

\item{r_names_to_merge}{list of room vectors to be merged}

\item{detail}{boolean, if FALSE only return hmax}
}
\value{
lists of hydraulic values: water exchange through openings and
floodwater depth in rooms
}
\description{
Analyse the hydraulics of the model
}
