% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_measure.R
\name{apply_measure}
\alias{apply_measure}
\title{Apply vulnerability reduction measures on the model}
\usage{
apply_measure(
  model,
  strategy_name,
  selection,
  hazard_range = getOption("floodam_building_hazard_range"),
  graph = getOption("floodam_building_graph"),
  save_pdf = FALSE,
  save_values = FALSE
)
}
\arguments{
\item{model}{the model to which measures will be applied}

\item{strategy_name}{the list of measures to apply}

\item{selection}{the rooms where measures will be applied}

\item{hazard_range}{list, default to getOption("floodam_building_hazard_range")}

\item{graph}{boolean, default to getOption("floodam_building_graph")}

\item{save_pdf}{boolean, default to FALSE}

\item{save_values}{boolean, default to FALSE}
}
\value{
a list with all elements related to the implementation of the measures (the model
without and with measures, the list of the measures, the costs and the efficiency)
}
\description{
Apply vulnerability reduction measures on the model
}
