## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----data, include = FALSE----------------------------------------------------
#> set up model to use example shipped with floodam
dataset = read.csv2(
  system.file(
    file.path(
      "extdata","component_elementary", "component_elementary.csv"
    ), 
    package = "floodam.building"
  )
)
selection = c("component_elementary", "v_min", "v_max", "v_support")
col_names = c("input file ID", "Min. value", "Max. value", "magnitude/support")

## ----echo=FALSE, results="asis"-----------------------------------------------
# loop to generate as many level 2 (##) headers and tables as elements contained in vector section
# the use of htmltools::tagList() and htmltools::tags$h2() is needed to create the sections programmatically with DT

section = unique(dataset[["category_activity_01"]])
section = section[section != "building"]

htmltools::tagList(
  lapply(
    section,
    function(x, cols, col_names){
      list(
        htmltools::tags$h2(paste0(ifelse(x=="equipment", "furniture/equipment", x),"s")), #level 2 (##) headers
        DT::datatable( #table
          dataset[
            dataset[["category_dwelling_01"]] == "furniture" &
            dataset[["category_activity_01"]] == x, cols
          ],
          rownames = FALSE,
          colnames = col_names,
          options = list(
            pageLength = 10, autoWidth = TRUE,
            lengthMenu = c(10, 15, 20, 25, 50, 100)
          )
        )
      )
    },
    cols = selection,
    col_names = col_names
  )
)


