# floodam.building <img src="man/figures/logo.png" align="right" width="25%" height="25%"/>
## Welcome to floodam.building

**floodam.building** is an R library for producing flood damage functions for
built assets (dwellings, economic activities).

This library has been developed within the French working group "GT AMC" which
aims at developing methodologies for the economic appraisal of flood management
policies. In this context, the development of **floodam.building** has received
the support of the French Ministry in charge of the Environment.

## What **floodam.building** can do

**floodam.building** is based on a decomposition of an asset (designated as a
model) which includes:

- the geometry of the building (typically how the building is designed in term
of rooms, width of wall, location of openings...)
- the elementary components used for the building (typically what is the type
and material for floors, ceilings, coatings, walls, openings etc.)
- the elementary components corresponding to the contents of the model
(typically what are the furniture, equipment, stock located in the building, and
where, and at which elevation). 

**floodam.building** include a collection of elementary damage components that
describe how elementary components may be impacted in terms of monetary damage
when flooded in specific conditions.

From this information, **floodam.building** can calculate the following outputs:

- an inventory of elementary components used for a specific model (how much and
how high)
- some general indicators (total surface, total value for contents)
- different type of damage functions:
    - absolute damage functions at model level or for sub-categories such as
    building, furniture (dwelling type), equipment and stock (activity type)
    - relative damage functions at model level or for sub-categories
- simulations of the interior hydraulics of the built assets (dwellings,
economic activities). See our dedicated [vignette](articles/hydraulic_model.html)

## What **floodam.building** cannot do

**floodam.building** cannot (and is not intended to):

- calculate damages from the intersection of hydraulic modeling, land use
modeling and damage functions. This is what **floodam.spatial** does.

**floodam.building** cannot (but should at some point be able to) :

- calculate the uncertainty of damage functions
- perform a sensitivity analysis of damage functions

## How to get **floodam.building**?

You can download and install it from this archive:
[www.floodam.org/library/floodam.building_1.7.6.0.tar.gz](http://www.floodam.org/library/floodam.building_1.7.6.0.tar.gz).

For instance, from a terminal, the command you can use is:

```{.bash filename="terminal"} 
R -e "install.packages(
    pkgs = 'http://www.floodam.org/library/floodam.building_1.7.6.0.tar.gz',
    type = 'source',
    repos = NULL,
    dependencies = TRUE)"
```

## How to help for the development of **floodam.building**?

Contact us.