#' Make an update of some useful data when you start with floodam
#
#' @param d_select integer, value of duration to be selected for plotting, default to getOption("floodam_building_d_select")
#' @param path list of useful paths, default to getOption("floodam_building_graph")
#' @param graph logical, default to getOption("floodam_building_graph")
#' @param verbose logical, default to getOption("floodam_building_verbose")
#' @return NULL
#' 
#' @export

update_floodam = function(
		d_select = getOption("floodam_building_d_select"),
		graph = getOption("floodam_building_graph"),
		path = getOption("floodam_building_path"),
		verbose = getOption("floodam_building_verbose")
	)
{
	update_elementary_damaging(
		path,
		hazard_range = 
			list(
				h = seq(-110, 400, 10),
				d = seq(0, 144, 12)
			),
		d_select = d_select,
		graph = graph,
		verbose = verbose
	)
	current = sort(names(floodam.building::BUILDING), decreasing = TRUE)[1]
	write(print_list(floodam.building::BUILDING[[current]]), file.path(path[["output"]], "building.txt"))
	invisible(NULL)
}
