#' Define some useful file names to use floodam
#
#' @param model_name character, name given to the model
#' @param file_name list of useful file names, that will be updated. Default to getOption("floodam_building_file_name")
#' @return list of useful paths, adjusted with model_name and type.
#' 
#' @export

update_file_name = function(
		model_name,
		file_name = getOption("floodam_building_file_name")
	)
{
	file_name[["log"]] = sprintf("%s.log", model_name)
	file_name[["output_damaging.csv"]] = sprintf("%s-damaging.csv", model_name)
	file_name[["output_damaging.pdf"]] = sprintf("%s-damaging.pdf", model_name)
	
	return(file_name)
}

