#' Update category damaging functions of a given type.
#' 
#' @param type character, type of model that is loaded, default to NULL
#' @param path list of useful paths, default to getOption("floodam_building_path")
#' @param file_name, list of useful file names, default to getOption("floodam_building_file_name")
#' @param verbose boolean, will floodam tells what it is doing, default to getOption("floodam_building_verbose")
#' @return NULL
#' @examples
#' \dontrun{
#' update_category("activity")
#' }
#' 
#' @export

update_category = function(
		type,
		path = getOption("floodam_building_path"),
		file_name = getOption("floodam_building_file_name"),
		verbose = getOption("floodam_building_verbose")
	)
{
	
	path = update_path(type = type, path = path)

	category_model = utils::read.csv2(
		file.path(path[["category"]], file_name[["category_model"]]),
		stringsAsFactors = FALSE
	)
	category_model = category_model[!is.na(category_model[["model_name"]]),]
	category = lapply(
		unique(category_model[["category"]]),
		update_category_damaging,
		category_model = category_model,
		path = path,
		file_name = file_name,
		verbose = verbose
	)
	category = lapply(
		category,
		calculate_weight_building,
		"relative"
	)
	names(category) = unique(category_model[["category"]])
	
	category_weight_building = t(sapply(
		category, 
		function(x){
			c(
				mean = mean(x[["weight_relative_building"]]), 
				median = stats::median(x[["weight_relative_building"]]), 
				max = max(x[["weight_relative_building"]])
			)
		}
	))
			
 	utils::write.csv2(
		 category_weight_building,
		 file.path(path[["category_output"]], "category-weight-building.csv")
	)
	
	invisible(NULL)
}
