#' Replace elements in some building part of a model
#' 
#' @param l, list, corresponding to a subset of building part a model
#' @param element, character of length 1, where in the list should be found 
#' what to change
#' @param type, character of length 2, giving correspondence between original 
#' and final type with names c('origin', 'final')
#' @param value, named vector, giving correspondence between new values (values) 
#' and old ones (names)
#' @return a list of same structure than l with types ans values changed.
#' @examples
#' \dontrun{
#' 	model_path = list(
#' 		data = system.file("extdata", package = "floodam.building"),
#' 		output = tempdir()
#' 	)
#' 	model = load_model(model = "adu_t", type = "adu", path = model_path)
#' 	temp = replace_in_building(
#'		l = model[["building"]][["element"]],
#'    	element = "ceiling",
#'    	type = c("origin" = "ceiling_1", "final" = "ceiling_1"),
#'    	value = c(
#'    	    "concrete" = "concrete",
#'    	    "cellular_plastic" = "cellular_plastic",
#'    	    "paint" = "paint",
#'    	    "260" = "200"
#'		)
#'	)
#' }
#' 
#' @export

replace_in_building = function(l, element, type, value) {
	replace_local = function(x, type, value) {
		if (type['origin'] %in% names(x)) {
			x[[type['final']]] = names(value)[value == x[[type['origin']]]]
			if (type['origin'] != type['final']) x[[type['origin']]] = NULL
		}
		return(x)
	}
	
	if (!is.vector(element) | length(element) != 1 | !is.character(element)) {
		stop("element must be a character of length 1.")
	}
	if (!is.vector(type) | length(type) != 2 & !is.character(type) | is.null(names(type)) | 
		suppressWarnings(!all(sort(names(type)) == c("final", "origin")))) {
		stop("type must be a character of length 2 with names c('origin', 'final').")
	}
	if (!is.vector(value) | is.null(names(value))) stop("value must be a named character.")

	if (is.list(l)) {
		selection = grep(sprintf("^%s", element), names(l))
		if (length(selection) > 0) {
			l[selection] = lapply(l[selection], replace_local, type, value)
			return(l)
		} else {
			return(lapply(l, replace_in_building, element, type, value))
		}
	} else {
		return(l)
	}
}

create_building_element = function(...) {
	list(...)
}