#' Replace a component in the building tables by another
#' 
#' @param component the model where a component will be replaced
#' @param replacement characteristics of the replacement
#' @param what the element to be replaced
#' @param sub_type add information to the component
#' @param selection the rooms where measures will be applied
#' @return the model with the changes on the XML data tables due to the measures
#' 
#' @keywords internal

replace_component = function(component, replacement, what, sub_type = NULL, selection = NULL) {
  
	if (is.null(selection)) selection = rep(TRUE, nrow(component))
	component = split(component, selection)
	
	change = keep_df_order(component[["TRUE"]], merge, replacement[c("material_origin", "material_final")], by.x = what, by.y = "material_origin", all.x = TRUE, suffixes = c("_x","_y"))
	change[[what]] = as.character(change[[what]])
	
	if (is.null(sub_type)) {
		change[[what]][!is.na(change[["material_final"]])] =
			as.character(change[["material_final"]][!is.na(change[["material_final"]])])
	} else {
		change[[what]][!is.na(change[["material_final"]]) & change[[sub_type]] == unique(as.character(replacement[["type"]]))] =
			as.character(change[["material_final"]][!is.na(change[["material_final"]]) & change[[sub_type]] == unique(as.character(replacement[["type"]]))])
	}
	change[["material_final"]] = NULL
	component[["TRUE"]] = change
	
	
	component = simplify2data_frame(component)

	
	return(component)
}
  
  

