#' Changes the origin by the final elements in the building
#' 
#' @param x the building list of the model to be adapted
#' @param correspondence the list of correspondence tables with the origin and final elements
#' @param storey where measures are applied
#' @param room where measures are applied
#' @param height under which measures are applied
#' @return the new building list
#' 
#' @keywords internal

make_substitution_building = function(x, correspondence, storey = NULL, room = NULL, height = +Inf) 
{ 
  substitute_element = function(e, correspondence, H, height, what = "type") {
    if (is.null(correspondence) | !(what %in% names(e))) return(e)
    if ("H" %in% names(e)) H = H + e[["H"]]
    if (e[[what]] %in% correspondence[["origin"]] & H <= height) e[[what]] = correspondence[correspondence[["origin"]] == e[[what]], "final"]
    return(e)
  }
  
  # follow_substitution = function(e, correspondence, H, height, what = "type") {
  #   if (is.null(correspondence) | !(what %in% names(e))) return(e)
  #   if ("H" %in% names(e)) H = H + e[["H"]]
  #   if (e[[what]] %in% correspondence[["origin"]]) {
  #     if (H <= height) return(correspondence[correspondence[["origin"]] == e[[what]], "final"])
  #     return(e[[what]])
  #   }
  # }
  
  building = x[["building"]]
  
  storey = if (is.null(storey)) names(building) else storey[storey %in% names(building)]
  for (st in storey) {
    all_room = c(grep("external", names(building[[st]]), value = TRUE), grep("room", names(building[[st]]), value = TRUE))
    room_selection = if (is.null(room)) all_room else room[room %in% all_room]
    H = x[["general"]][["H"]] + building[[st]][["H"]]
    for (ro in room_selection) {
      if (!is.null(building[[st]][[ro]][["H"]])) H = H + building[[st]][[ro]][["H"]]
      building[[st]][[ro]] = substitute_element(building[[st]][[ro]], correspondence[["floor"]], H, height, what = "floor")
      building[[st]][[ro]] = substitute_element(building[[st]][[ro]], correspondence[["ceiling"]], H, height, what = "ceiling")
      building[[st]][[ro]] = substitute_element(building[[st]][[ro]], correspondence[["baseboard"]], H, height, what = "baseboard")
      for (wa in grep("^wall", names(building[[st]][[ro]]), value = TRUE)) {
        building[[st]][[ro]][[wa]] = substitute_element(building[[st]][[ro]][[wa]], correspondence[["wall"]], H, height)
        for (op in grep("^opening", names(building[[st]][[ro]][[wa]]))) {
          building[[st]][[ro]][[wa]][[op]] = substitute_element(building[[st]][[ro]][[wa]][[op]], correspondence[["opening"]], H, height)
        }
        for (co in grep("^coating", names(building[[st]][[ro]][[wa]]))) {
          building[[st]][[ro]][[wa]][[co]] = substitute_element(building[[st]][[ro]][[wa]][[co]], correspondence[["coating"]], H, height)
        }
      }
    }
  }	
  return(building)
  
}

