#' Transform a list in xml
#' 
#' @param item something. If a list, recursive call to list2xml is made, if not the value to add to the item.
#' @param tag the tag that will be used for the item
#' @return xml object
#' 
#' @keywords internal

list2xml <- function(item, tag = "model") {

  # Just a textnode, collapsing vector with semi-colon
  if (typeof(item) != 'list') {
		return(XML::xmlNode(tag, paste(item, collapse=",")))
  }

  # Create the node
  if (identical(names(item), c("text", "_attrs"))) {
    # Special case a node with text and attributes
    xml = XML::xmlNode(tag, item[['text']])
  } else {
    # Node with child nodes
    xml = XML::xmlNode(tag)
    for (i in 1:length(item)) {
      if (names(item)[i] != "_attrs") {
        xml = XML::append.xmlNode(xml, list2xml(item[[i]], names(item)[i]))
      }
    }    
  }

  # Add attributes to node
  attrs = item[["_attrs"]]
  for (name in names(attrs)) {
    XML::xmlAttrs(xml)[[name]] = attrs[[name]]
  }
  return(xml)
}
