#' Define some useful path to use floodam
#
#' @param input define base directory where to find input data. Default to "data-floodam"
#' @param output defines base directory where to find input data. Default to "data-floodam"
#' @return a list of useful paths, based on expected organization in data-floodam
#' Create paths for outputs also.
#' 
#' @export

init_create_path = function(input = "data-floodam", output = "output-floodam")
{
	if (!is.character(input)) {
		input = as.character(input)
		warning(sprintf("input not of class character."))
	}
	if (!is.character(output)) {
		output = as.character(output)
		warning(sprintf("output not of class character."))
	}
	if (length(input) > 1) {
		input = input[1]
		warning(sprintf("input of length > 1, only first value taken."))
	}
	if (length(output) > 1) {
		output = output[1]
		warning(sprintf("output of length > 1, only first value taken."))
	}
	if (length(input) == 0) stop("check value of input")
	if (length(output) == 0) stop("check value of output")

	path = list()

	# selected data
	path[["data"]] = input
	path[["damaging"]] =	system.file("extdata/component_elementary",	package = "floodam.building")
	path[["parameter"]] = system.file("extdata/parameter", package = "floodam.building")
	path[["adaptation"]] = file.path(path[["data"]], "adaptation")
	
	# output
	path[["output"]] = output
	path[["damaging_output"]] = file.path(path[["output"]], "damaging")
	path[["damaging_output_csv"]] = file.path(path[["damaging_output"]], "csv")
	path[["damaging_output_pdf"]] = file.path(path[["damaging_output"]], "pdf")
		
	# Create paths, if missing
	lapply(path, dir.create, showWarnings = FALSE, recursive = TRUE)

  return(path)
}
