#' Extract information at wall level (version 2)
#' 
#' @param building list describing the building
#' @param pattern list giving what to look for in a wall
#' @param parameter data.frame giving elements present in building
#'
#' @return a data.frame of informations extracted, ordered.
#' 
#' @keywords internal

extract_wall_02 = function(building, pattern, parameter) {	
	pattern = construct_data_frame_pattern(pattern)
	selection = grep("storey", names(building), value = TRUE)

	result = simplify2data_frame(
		mapply(
			extract_something_from_storey,
			building[selection], selection, 
			MoreArgs = list(pattern = pattern, what = "wall"),
			SIMPLIFY = FALSE
		)
	)
	if (!is.null(parameter)) {
		result = merge(result, parameter, all.x = TRUE, by = "type")
	}

	result[["order"]] = order_wall(result[["wall"]])
	result = result[order(result[["storey"]], result[["room"]], result[["order"]]), ]

	result[["width"]] = calculate_wall_width_02(result[c("storey", "room", "x", "y")])

	n = ceiling(log(nrow(result) + 1) / log(10))
	pattern = sprintf("wall_%%0%dd", n)
	rownames(result) = result[["id_wall"]] = sprintf(pattern, seq(nrow(result)))
	
	result
}

#' Extract information at wall level (version 3)
#' 
#' @param model_building a list that should represent a building version of model
#' @param building list giving the structure of building, default to
#' floodam.building::BUILDING
#'
#' @return a data.frame of informations extracted, ordered.
#'
#' @keywords internal

extract_wall_03 = function(model_building, building = floodam.building::BUILDING) {
	pattern = building[[model_building[["general"]][["version"]]]]
	pattern = pattern[["building"]][["storey"]][["generic"]][["wall"]]
	pattern = construct_data_frame_pattern(pattern)
	selection = grep("building", names(model_building), value = TRUE)

	result = simplify2data_frame(
		mapply(
			extract_something_from_building,
			model_building[selection],
			selection, 
			MoreArgs = list(pattern = pattern, what = "wall"),
			SIMPLIFY = FALSE
		)
	)

	result[
		order(
			result[["building"]],
			result[["storey"]],
			order_room(result[["room"]]),
			order_wall(result[["wall"]])
		), 
	]
}