#' Extract information from a storey
#' 
#' @param storey a list that should represent a storey.
#' @param storey_name a character giving the storey name.
#' @param pattern the pattern that will be used to extract information.
#' @param what a character indicating what should be extracted. default to "room".
#' @return a data.frame of informations extracted.
#' 
#' @keywords internal

extract_something_from_storey = function(storey, storey_name, pattern, what = "room") {
	pattern[["storey"]] = storey_name
	
	selection = names(storey)[sapply(storey, is.list)]
	if (what == "room") {
		simplify2data_frame(
			mapply(
				extract_information,
				storey[selection],
				selection, 
				MoreArgs = list(
					pattern = pattern,
					type_name = what
				),
				SIMPLIFY = FALSE))
	} else {	
		simplify2data_frame(
			mapply(
				extract_something_from_room,
				storey[selection],
				selection,
				MoreArgs = list(
					pattern = pattern,
					what = what
				),
				SIMPLIFY = FALSE
			)
		)
	}
}
