#' Extract information from a building
#' 
#' @param building a list that should represent a building.
#' @param building_name a character giving the building name.
#' @param pattern the pattern that will be used to extract information.
#' @param what a character indicating what should be extracted. Default to "storey".
#' @return a data.frame of informations extracted.
#' 
#' @keywords internal

extract_something_from_building = function(building, building_name, pattern, what = "storey") {
	pattern[["building"]] = building_name

	selection = names(building)[sapply(building, is.list)]
	if (what %in% c("storey",  "protection")) {
		selection = grep(what, selection, value = TRUE)
		simplify2data_frame(
			mapply(extract_information, building[selection], selection, 
				MoreArgs = list(pattern = pattern, type_name = what),
				SIMPLIFY = FALSE))
	} else {
		selection = grep("storey", selection, value = TRUE)
		simplify2data_frame(
			mapply(extract_something_from_storey, building[selection], selection,
			MoreArgs = list(pattern = pattern, what = what),
			SIMPLIFY = FALSE))
	}
}
