#' Extract information at opening level
#' 
#' @param model_building a list that should represent a building version of model
#' @return a data.frame of informations extracted, ordered
#' 
#' @keywords internal

extract_opening_03 = function(model_building) {
	pattern = floodam.building::BUILDING[[model_building[["general"]][["version"]]]]
	pattern = pattern[["building"]][["storey"]][["generic"]][["wall"]][["opening"]]
	pattern = construct_data_frame_pattern(pattern)
	selection = grep("building", names(model_building), value = TRUE)

	result = simplify2data_frame(
		mapply(
			extract_something_from_building,
			model_building[selection],
			selection, 
			MoreArgs = list(
				pattern = pattern,
				what = "opening"
			),
			SIMPLIFY = FALSE
		)
	)

	if (is.null(result)) {
		return(NULL)
	}

	result[order(result[["building"]], result[["storey"]], order_room(result[["room"]]), order_wall(result[["wall"]])),]
}

extract_opening_02 = function(building, pattern, parameter = NULL, file_log) {		
	pattern = construct_data_frame_pattern(pattern)
	selection = grep("storey", names(building), value = TRUE)

	result = simplify2data_frame(
		mapply(
			extract_something_from_storey,
			building[selection],
			selection, 
			MoreArgs = list(
				pattern = pattern,
				what = "opening"
			),
			SIMPLIFY = FALSE
		)
	)
	if (is.null(result)) {
		if (!is.null(file_log)) {
			report = "\n\t- No opening found."
			write(report, file = file_log, append = TRUE)
		}
		return(NULL)
	}
	if (!is.null(parameter)) {
		result = merge(result, parameter, all.x = TRUE, by = "type")
	}
	
	result[order(result[["storey"]], result[["room"]], result[["wall"]]),]
}
