#' Creates declination of model according to the declination file
#
#' @param model the selected model to decline
#' @param strategy_name the list of declination measures to apply
#' @param combination table with the characteristics of each version to create
#' @param meas boolean saying if adaptation measure should be applied or not
#' @param selection the rooms where material measures will be applied
#' @param core number of cores allocated to the creation of the versions, default equals one
#' @return a list with the new xmls and damaging
#' 
#' @keywords internal

declinaison_building = function(model, strategy_name, combination, meas = FALSE, selection = NULL, core = 1)
{
  
  core = parallel::detectCores()
  
  #l_maquette = sapply(rownames(combination),function(x) NULL)

  #Functions changing elements
  change_wall = function(element, material){
    if (element[["wall_type"]] == "load_bearing_wall" & !is.null(material[["wall_load_bearing_material"]])){
      element[["material"]] = as.character(material[["wall_load_bearing_material"]])
      element[["render"]] = as.character(material[["wall_load_bearing_render"]])
    } else if (element[["wall_type"]] == "partition" & !is.null(material[["wall_partition_material"]])){
      element[["material"]] = as.character(material[["wall_partition_material"]])
    } else if (element[["wall_type"]] == "lining" & !is.null(material[["wall_lining_material"]])){ #& material[["wall_lining_material"]] != "other") {
      element[["material"]] = as.character(material[["wall_lining_material"]])
      element[["insulating"]] = as.character(material[["wall_lining_insulating"]])
    }
    return(element)
  }

  change_coating = function(element, material){
    if (!is.null(material[["coating_material"]])){
      element[["material"]] = as.character(material[["coating_material"]])
    }
    return(element)
  }

  change_opening = function(element, material){
    if (element[["opening_type"]] != "door" & !is.null(material[["opening_window_material"]])){
      element[["material"]] = as.character(material[["opening_window_material"]])
      element[["shutter"]] = as.character(material[["opening_window_shutter"]])
    } else if (length(grep("garage", element[["material"]])) == 1 & !is.null(material[["opening_door_garage_material"]])){
      element[["material"]] = as.character(material[["opening_door_garage_material"]])
    } else if (length(grep("exterior", element[["material"]])) == 1 & !is.null(material[["opening_door_ext_material"]])){
      element[["material"]] = as.character(material[["opening_door_ext_material"]])
    } else if (length(grep("entrance", element[["material"]])) == 1 & !is.null(material[["opening_door_ext_material"]])){
      element[["material"]] = as.character(material[["opening_door_ext_material"]])
    } else if (element[["opening_type"]] == "door" & length(grep("garage", element[["material"]])) != 1
               & length(grep("exterior", element[["material"]])) != 1 & length(grep("entrance", element[["material"]])) != 1
               & !is.null(material[["opening_door_int_material"]])){
      element[["material"]] = as.character(material[["opening_door_int_material"]])
    }
    return(element)
  }
  
  # change_opening_2 = function(element, material){
  #   if (element[["opening_type"]] != "door"){
  #     element[["material"]] = as.character(material)
  #     #element[["shutter"]] = as.character(material)
  #   }
  #   
  #   if (element[["opening_type"]] == "door") {
  #     if (length(grep("garage", element[["material"]])) == 1 & length(grep("garage", material)) == 1){
  #       element[["material"]] = as.character(material)
  #     }
  #     if (length(grep("entrance", element[["material"]])) == 1 & length(grep("exterior", material)) == 1){
  #       element[["material"]] = as.character(material)
  #     }
  #     if (length(grep("entrance", element[["material"]])) == 1 & length(grep("entrance", material)) == 1){
  #       element[["material"]] = as.character(material)
  #     }
  #     if (length(grep("garage", element[["material"]])) != 1 & length(grep("garage", material)) != 1
  #        & length(grep("exterior", element[["material"]])) != 1 & length(grep("exterior", material)) != 1
  #        & length(grep("entrance", element[["material"]])) != 1 & length(grep("entrance", material)) != 1){
  #       element[["material"]] = as.character(material)
  #       }
  #   }
  #   
  #   return(element)
  # }
  
  

  change_floor = function(element, material){
    if (!is.null(material[["floor_material"]])){
      element[["material"]] = as.character(material[["floor_material"]])
      element[["coating"]] = as.character(material[["floor_coating"]])
    }
    return(element)
  }

  change_ceiling = function(element, material){
    if (!is.null(material[["ceiling_material"]])) {
      element[["material"]] = as.character(material[["ceiling_material"]])
      element[["coating"]] = as.character(material[["ceiling_coating"]])
      if (!(material[["ceiling_material"]] %in% c("concrete", "glued_mineral", "glued_polystyrene"))){
        element[["insulating"]] = as.character(material[["ceiling_insulating"]])
      } else element[["insulating"]] = NULL
    }
    return(element)
  }

  
  # hazard_range.2 = getOption("floodam_building_hazard_range")
  # hazard_range.2[["d"]] = c(0, 12, 24, 48, 72, 120)

  #Create a file with the name of the strategy
  model[["path"]][["declinaison_output"]] = file.path(model[["path"]][["model_output_damaging"]], sprintf("%s", strategy_name))
  #model[["path"]][["declinaison_output"]] = file.path(getwd(), sprintf("%s", strategy_name))
  if (!file.exists(model[["path"]][["declinaison_output"]])) {
    dir.create(path = model[["path"]][["declinaison_output"]])
  }

  #for (i in 1:length(name_maquette)){
    #message(sprintf("Maquette %s...\n", name_maquette[i]))

  create_version = function(i){  
    #Change material
    material = combination[i,]
    model_new = model
  
    model_new[["building"]][["element"]][["wall"]] = lapply(model_new[["building"]][["element"]][["wall"]], change_wall, material)
    model_new[["building"]][["element"]][["coating"]] = lapply(model_new[["building"]][["element"]][["coating"]], change_coating, material)
    model_new[["building"]][["element"]][["opening"]] = lapply(model_new[["building"]][["element"]][["opening"]], change_opening, material)
    model_new[["building"]][["element"]][["floor"]] = lapply(model_new[["building"]][["element"]][["floor"]], change_floor, material)
    model_new[["building"]][["element"]][["ceiling"]] = lapply(model_new[["building"]][["element"]][["ceiling"]], change_ceiling, material)
    if ("dilapidation" %in% names(combination)){
      model_new[["building"]][["general"]][["dilapidation"]] = as.numeric(as.character(material[["dilapidation_value"]]))
    }
  
    #Update the tables with the substitute elements
    model_new = analyse_model(model_new, stage = c("extract", "damaging"))
    model_new[["furniture"]] = model[["furniture"]]
  
    #Apply vulnerability reduction measures
    if (meas == TRUE){
      adaptation = apply_measure(model_new, strategy_name, selection, graph = FALSE)
    }
    
    #Add the new model in the list of maquettes
    #l_maquette[[name_maquette[i]]][["buidling"]] = model_new[["building"]]
    #l_maquette[[name_maquette[i]]][["damaging"]] = model_new[["damaging"]][["absolute"]][["building"]]
  
    #Save building and damaging
    model[["path"]][["declinaison_output_version"]] = file.path(model[["path"]][["declinaison_output"]], sprintf("%s", rownames(combination)[i]))
    if (!file.exists(model[["path"]][["declinaison_output_version"]])) {
      dir.create(path = model[["path"]][["declinaison_output_version"]])
    }
    # XML::saveXML(list2xml(model_new[["building"]]), file.path(model[["path"]][["declinaison_output_version"]], sprintf("%s_building.xml", rownames(combination)[i])), 
    #     encoding = "UTF-8", prefix = '<?xml version="1.0" encoding="UTF-8"?>\n')
    #utils::write.csv2(model_new[["damaging"]][["absolute"]][["building"]], file.path(model[["path"]][["declinaison_output_version"]], sprintf("%s.damaging.building.csv", rownames(combination)[i])))
    utils::write.csv2(model_new[["damaging"]][["absolute"]][["total"]], file.path(model[["path"]][["declinaison_output_version"]], sprintf("%s_damaging_total.csv", rownames(combination)[i])))
    
    if (meas == TRUE){
      #utils::write.csv2(adaptation[["model_adapted"]][["damaging"]][["absolute"]][["building"]], file.path(model[["path"]][["declinaison_output_version"]], sprintf("%s_damaging_building_meas.csv", rownames(combination)[i])))
      utils::write.csv2(adaptation[["model_adapted"]][["damaging"]][["absolute"]][["total"]], file.path(model[["path"]][["declinaison_output_version"]], sprintf("%s_damaging_total_meas.csv", rownames(combination)[i])))
      utils::write.csv2(adaptation[["costs"]][["detail"]], file.path(model[["path"]][["declinaison_output_version"]], sprintf("%s_cost.csv", rownames(combination)[i])))
    }
    
  }
  
  parallel::mclapply(1:nrow(combination), create_version, mc.cores = core)
  #parallel::mclapply(1:100, create_version, mc.cores = core)
  
  # fun = function(){
  #   a = Sys.time()
  #   parallel::mclapply(1:10, create_version, mc.cores = 1)
  #   Sys.time()-a
  #   }
  
  
  #return(l_maquette)
}






