#' Information on activity.
#'
#' List of data.frame giving complementary information on activities.
#'
#' @format A list of data.frame:
#' **category**: data.frame giving the correspondence between models and 
#' category of activities
#'
#' - **model_name** character, name of the model
#' - **category** character, name of the category of activity
#' - **category_label_fr** character, label in French
#' - **APE_05** character, APE code at level 5 of the model
#' - **APE_05_label_fr** character, label in French of the APE code
#' - **n_employee** double, number of employee attached to the given model
#' 
#' **typology**: data.frame giving the correspondence between category of 
#' activities and APE codes at level 5
#'
#' - **APE_05** character, APE code at level 5
#' - **type** character, type of stake, only those of type activity are used
#'   for extrapolation
#' - **category** character, name of the category of activity attached to
#'   the APE code
#' - **category_label_fr** character, label in French
#' - **APE_05_label_fr** character, label in French of the APE code
#' 
#' **esane**: data.frame giving the correspondence between category of
#'   activities and APE codes at level 5, with information coming frome esane
#'   data base (INSEE)
#'
#' - **APE_05** character, APE code at level 5
#' - **type** character, type of stake, only those of type activity are used
#'   for extrapolation
#' - **category** character, name of the category of activity attached to
#'   the APE code
#' - **category_label_fr** character, label in French
#' - **APE_05_label_fr** character, label in French of the APE code
#' - **n** double, number of enterprises for all the activities in France of
#'   the given APE code
#' - **employee** double, number of employee for all the activities in
#'   France of the given APE code
#' - **equipment** double, value of equipment for all the activities in
#'   France of the given APE code
#' - **stock** double, value of stock for all the activities in France of
#'   the given APE code
#' - **level** factor, level at which data could be extracted from esane
#'   data base (N1, N2, N3 or N5) or "no data" when nothing was available
#' - **ACTENTNOMESS** double, value of field ACTENTNOMESS, number of
#'   enterprises for all the activities in France of the given APE code
#' - **EMPSALNOMESS** double, value of field EMPSALNOMESS, number of
#'   employees for all the activities in France of the given APE code
#' - **BAC123VALESE** double, value of field BAC123VALESE, value of specific
#'   equipment for all the activities in France of the given APE code
#' - **BAC124VALESE** double, value of field BAC124VALESE, value of non
#'   specific equipment  for all the activities in France of the given
#'   APE code
#' - **BAC152VALESE** double, value of field BAC152VALESE, value of stock
#'   (input) for all the activities in France of the given APE code
#' - **BAC155VALESE** double, value of field BAC155VALESE, value of stock
#'   (intermediate) for all the activities in France of the given APE code
#' - **BAC156VALESE** double, value of field BAC156VALESE, value of stock
#'   (output) for all the activities in France of the given APE code
#' 
"ACTIVITY"

#' Expected structure of building files
#' 
#' Expected elements of building files (building.xml or building.yaml).
#'
#' @format A list of element with some useful information on their status:
#' 
#' - **STATUS** character of length 1 with value MANDATORY or OPTIONAL
#' - **VALUE** character of length 1 with value giving the types of value
#' - **SEVERAL** optional, boolean of length 1. If true the items may be 
#'   encountered several times
#' - **ID** character of length 1 with value 'GLOBAL' or 'LOCAL'
#' - **subitems** optional, some subitems, which are lists with the same
#'   expected items
"BUILDING"

#' Elementary component
#'
#' All available elementary components.
#'
#' @format A data.frame:
#'
#' - **row_name** name of the elementary component
#' - **category_vulnerability** factor giving the category of vulnerability
#' - **v_min** integer, minimum value
#' - **v_max** integer, maximum value
#' - **v_unit** factor, unit for v_min and v_max
#' - **v_support** factor, how should be calculated value
#' - **component_elementary_label_fr** label in French
#' - **category_activity_01** factor, categorisation for activity at level 1
#' - **category_activity_02** factor, categorisation for activity at level 2
#' - **category_dwelling_01** factor, categorisation for dwelling at level 1
#' 
"COMPONENT_ELEMENTARY"

#' Elementary damage functions.
#'
#' Elementary damage functions of all available elementary components.
#'
#' @format A list of element of class elementary_damaging:
#'
#' - **value** array of damage with 3 dimensions: h (height), d (duration),
#' and action
#' - **h_action** attribute, character of same length as action, giving the
#'   height that shall be used for each action
#' - **dilapidation** attribute, numeric of same length as action, giving the
#'   dilapidation to be used for each action
#' - **support** attribute, character of same length as action, giving the
#'   support to be used for each action
#' - **component** attribute, character of length 1 giving the classification
#'   of the elementary component
#' 
"DAM"

#' Default value for plotting
#'
#' Default value for plotting
#'
#' @format A data.frame:
#'
#' - **row_name** name of the elementary component
#' - **col** color to be used
#' - **lwd** line width to be used
#' - **density** density to be used
#' 
"LEGEND"

#' model of a single storey auxiliary dwelling unit (adu)
#'
#' @format Preloaded (with function `load_model()`) input file of a single 
#' storey auxiliary dwelling unit (adu). At this stage, it is an object of 
#' class 'model' formatted as a list. It is the equivalent of the stage "load"
#' in function `analyse_model()`, thus stages 'extract' and 'damaging' should 
#' be applied in order to generate the damage function. Inside adu_t you will
#' find:
#'
#' - **name** slot of length 1 containing the model name.
#' - **type** slot of length 1 containing the model type.
#' - **category** slot of length 1 containing the model category.
#' - **path** list of length 7 containing paths from the information should be
#'   loaded or where the information should be stored.
#' - **file_name** list of length 9 containing the file names to use to load or
#'   store information.
#' - **building** list of length 3 containing the information from the building
#'   file.
#' - **data_table** list of length 1 containing the information from the 
#'   furniture file.
#' 
"adu_t"

#' model of a two-storey auxiliary dwelling unit (adu)
#'
#' @format Preloaded (with function `load_model()`) input file of a two-storey
#' auxiliary dwelling unit (adu). At this stage, it is an object of class 
#' 'model' formatted as a list. It is the equivalent of the stage "load" in 
#' function `analyse_model()`, thus stages 'extract' and 'damaging' should be
#' applied in order to generate the damage function. Inside adu_t you will 
#' find:
#'
#' - **name** slot of length 1 containing the model name.
#' - **type** slot of length 1 containing the model type.
#' - **category** slot of length 1 containing the model category.
#' - **path** list of length 7 containing paths from the information should be
#'   loaded or where the information should be stored.
#' - **file_name** list of length 9 containing the file names to use to load or
#'   store information.
#' - **building** list of length 3 containing the information from the building
#'   file.
#' - **data_table** list of length 1 containing the information from the 
#'   furniture file.
#' 
"adu_t_basement"

#' model of a three-storey auxiliary dwelling unit (adu)
#'
#' @format Preloaded (with function `load_model()`) input file of a three-storey
#' auxiliary dwelling unit (adu) equipped with an elevator. At this stage, it 
#' is an object of class 'model' formatted as a list. It is the equivalent of 
#' the stage "load" in function `analyse_model()`, thus stages 'extract' and 
#' 'damaging' should be applied in order to generate the damage function. 
#' Inside adu_t you will find:
#'
#' - **name** slot of length 1 containing the model name.
#' - **type** slot of length 1 containing the model type.
#' - **category** slot of length 1 containing the model category.
#' - **path** list of length 7 containing paths from the information should be
#'   loaded or where the information should be stored.
#' - **file_name** list of length 9 containing the file names to use to load or
#'   store information.
#' - **building** list of length 3 containing the information from the building
#'   file.
#' - **data_table** list of length 1 containing the information from the 
#'   furniture file.
#' 
"adu_elevator"

#' model of a single storey auxiliary dwelling unit (adu)
#'
#' @format Preloaded (with function `load_model()`) input file of a single 
#' storey auxiliary dwelling unit (adu). This model differs from `adu_t` in its
#' layout: this version is a 2-room ADU instead of a 4-room ADU. At this stage,
#' it is an object of class 'model' formatted as a list. It is the equivalent
#' of the stage "load" in function `analyse_model()`, thus stages 'extract' and
#' 'damaging' should be applied in order to generate the damage function. 
#' Inside adu_t_2room you will find:
#'
#' - **name** slot of length 1 containing the model name.
#' - **type** slot of length 1 containing the model type.
#' - **category** slot of length 1 containing the model category.
#' - **path** list of length 7 containing paths from the information should be
#'   loaded or where the information should be stored.
#' - **file_name** list of length 9 containing the file names to use to load or
#'   store information.
#' - **building** list of length 3 containing the information from the building
#'   file.
#' - **data_table** list of length 1 containing the information from the 
#'   furniture file.
#' 
"adu_t_2room"

#' model of a single storey auxiliary dwelling unit (adu)
#'
#' @format Preloaded (with function `load_model()`) input file of a single 
#' storey auxiliary dwelling unit (adu). This model is similar to `adu_t_2room`
#' regarding the layout but it differs in the way of defining it: instead of
#' declaring a big room, this model uses the layout of `adu_t` but uses 
#' "invisible" walls to accomplish the 2-room layout. At this stage, it is an
#' object of class 'model' formatted as a list. It is the equivalent of the 
#' stage "load" in function `analyse_model()`, thus stages 'extract' and
#' 'damaging' should be applied in order to generate the damage function. 
#' Inside adu_t_invisible you will find:
#'
#' - **name** slot of length 1 containing the model name.
#' - **type** slot of length 1 containing the model type.
#' - **category** slot of length 1 containing the model category.
#' - **path** list of length 7 containing paths from the information should be
#'   loaded or where the information should be stored.
#' - **file_name** list of length 9 containing the file names to use to load or
#'   store information.
#' - **building** list of length 3 containing the information from the building
#'   file.
#' - **data_table** list of length 1 containing the information from the 
#'   furniture file.
#' 
"adu_t_invisible"

#' model of a single storey auxiliary dwelling unit (adu)
#'
#' @format Preloaded (with function `load_model()`) input file of a single 
#' storey auxiliary dwelling unit (adu). This model differs from `adu_t` in its
#' layout. At this stage, it is an object of class 'model' formatted as a list.
#' It is the equivalent of the stage "load" in function `analyse_model()`, thus
#' stages 'extract' and 'damaging' should be applied in order to generate the
#' damage function. Inside adu_t you will find:
#'
#' - **name** slot of length 1 containing the model name.
#' - **type** slot of length 1 containing the model type.
#' - **category** slot of length 1 containing the model category.
#' - **path** list of length 7 containing paths from the information should be
#'   loaded or where the information should be stored.
#' - **file_name** list of length 9 containing the file names to use to load or
#'   store information.
#' - **building** list of length 3 containing the information from the building
#'   file.
#' - **data_table** list of length 1 containing the information from the 
#'   furniture file.
#' 
"adu_l"