#' Creates declination of model according to the declination file
#
#' @param declinaison a dataframe with the material to be used to create the declinations
#' @param condition specify if some materials should be linked (NULL, "all", "wall")
#' @param select select only one sub_type of declination
#' @return a dataframe with one row per declination
#' 
#' @keywords internal

create_combination = function(declinaison, condition = NULL, select = NULL)
{

  #Select only some declination lines
  if (!is.null(select)){
    declinaison = declinaison[which(declinaison[["sub_type"]] == select),]
  }
  
  elem = split(declinaison, declinaison[c("type", "sub_type", "part")], drop = TRUE)
  mat_decli = lapply(elem, function(x) {x = x[["final"]]})
  combination = expand.grid(mat_decli)
  names(combination) = sub("./.", "_", names(combination), fixed = TRUE)

  if (!is.null(condition)){
    if (condition == "all"){
      	#Select the rows for which the material of all the openings is the same
	selection = Reduce(union, lapply(list("PVC", "wood", "metal|aluminium"), function(x) Reduce(intersect, lapply(list("opening_door_ext_material", "opening_door_garage_material", "opening_window_material", "opening_window_shutter"), function(y) grep(x, as.character(combination[ , y]))))))
  	combination = combination[selection, ] 
 	#Select the rows for which the insulating are the same	
	selection = Reduce(union, lapply(list("mineral", "plastic"), function(x) Reduce(intersect, lapply(list("ceiling_insulating", "wall_lining_insulating"), function(y) grep(x, as.character(combination[ , y]))))))
  	combination = combination[selection, ]
	#Select the rows for which the wall materials are the same
	selection = Reduce(union, lapply(list("placostil", "dry", "masonry"), function(x) Reduce(intersect, lapply(list("wall_partition_material", "wall_lining_material"), function(y) grep(x, as.character(combination[ , y]))))))
	combination = combination[selection, ]
} 
}
  rownames(combination) = paste("V", sep ="_", seq(nrow(combination)))
  return(combination)
}
