#' Add the detail and costs of the changes of coating or the addition of a coating on a changed wall
#' 
#' @param measure_cost list of the different cost to be updated with the replacement measure
#' @param model the model without measure
#' @param model_adapted the model with adaptation measures
#' @return measure_cost, a list with the cost of prevention (only material modification) and repair (repair due to flood and modification of material at the same time) and the details
#' 
#' @keywords internal
  
coating_adaptation_cost = function(measure_cost, model, model_adapted) {
  
  #Initialization
  support = 0
  cost_prevention = 0
  cost_repair = 0
  cost_crawlspace = 0
  cost_slab = 0
  
  #Search for diffence  in wall material between reference and component due to adaptation
  ind_wall = which(as.character(model_adapted[["data_table"]][["wall"]][["material"]]) != as.character(model[["data_table"]][["wall"]][["material"]]))
  if (length(ind_wall) != 0){
    wall = model[["data_table"]][["wall"]][ind_wall, c("room", "wall")]
  }

  for (i in 1: length(model[["data_table"]][["coating"]][,1])){
    #Different coating between model and model_adapted
    if (as.character(model_adapted[["data_table"]][["coating"]][["material"]][i]) != as.character(model[["data_table"]][["coating"]][["material"]][i])){
      support_i = model[["data_table"]][["coating"]][["surface"]][i]
      
      ind_final = which(row.names(floodam.building::COMPONENT_ELEMENTARY) == model_adapted[["data_table"]][["coating"]][["coating_elementary_component"]][i])
      value_final = mean(c(floodam.building::COMPONENT_ELEMENTARY[["v_min"]][ind_final],floodam.building::COMPONENT_ELEMENTARY[["v_max"]][ind_final]))
      ind_origin = which(row.names(floodam.building::COMPONENT_ELEMENTARY) == model[["data_table"]][["coating"]][["coating_elementary_component"]][i])
      value_origin = mean(c(floodam.building::COMPONENT_ELEMENTARY[["v_min"]][ind_final],floodam.building::COMPONENT_ELEMENTARY[["v_max"]][ind_final]))
      
      support = support + support_i
      cost_prevention = cost_prevention + value_final*support_i
      cost_repair = cost_repair + (value_final - value_origin)*support_i
    }
    
    #Change of wall material and same coating
    #If ind_mat is not empty, the material of the wall for model[["data_table"]][["coating"]][i] has changed
    if (length(ind_wall) != 0){
      ind_mat = intersect(which(as.character(wall[["room"]]) == as.character(model[["data_table"]][["coating"]][["room"]][i])), 
        which(as.character(wall[["wall"]]) == as.character(model[["data_table"]][["coating"]][["wall"]][i])))
      if (length(ind_mat) != 0 & as.character(model_adapted[["data_table"]][["coating"]][["material"]][i]) == as.character(model[["data_table"]][["coating"]][["material"]][i])){
        support_i = model[["data_table"]][["coating"]][["surface"]][i]
      
        ind_coat = which(row.names(floodam.building::COMPONENT_ELEMENTARY) == model_adapted[["data_table"]][["coating"]][["coating_elementary_component"]][i])
        value_coat = mean(c(floodam.building::COMPONENT_ELEMENTARY[["v_min"]][ind_coat],floodam.building::COMPONENT_ELEMENTARY[["v_max"]][ind_coat]))
      
        support = support + support_i
        cost_prevention = cost_prevention + value_coat * support_i
      }
    }
    
  }
  
    
  measure_cost[["prevention"]] = measure_cost[["prevention"]] + cost_prevention
  measure_cost[["repair"]] = measure_cost[["repair"]] + cost_repair
  if (cost_prevention != 0){ #Avoid too much details about the measures not realised
    measure_cost[["detail"]] = rbind(measure_cost[["detail"]], data.frame(
      measure_name = "coating_material", origin = "/", final = "/", v_support = "surface", 
      support = support, prevention_cost = cost_prevention, repair_cost = cost_repair, crawlspace_cost = 0, slab_cost = 0))
    }

	return(measure_cost)
}
  
  

