#' Check some integrity of floodam
#' 
#' @param check boolean
#' @param file_name character
#' @param path character
#' @return NULL
#' 
#' @export

check_floodam = function(
    check = getOption("floodam_building_check"),
    file_name = getOption("floodam_building_file_name"),
    path = getOption("floodam_building_path")
  )
{
  
  if (check != TRUE) {
    message("floodam has not been checked\n")
    return()
  }
  
  current = sort(names(floodam.building::BUILDING), decreasing = TRUE)[1]
  write(paste("Date of check:", Sys.Date(), "\n"), file.path(path[["check"]], file_name[["check"]]))
  check_damaging_table(file.path(path[["check"]], file_name[["check"]]))
  
  write(print_list(floodam.building::BUILDING[[current]]), file.path(path[["check"]], file_name[["BUILDING"]]))
  
  message(sprintf("floodam has been checked. See %s for details\n", file.path(path[["check"]], file_name[["check"]])))
  
  return(NULL)
}

