#' Check if all items in a nested list are unique.
#' 
#' @param element a nested list
#' @description 
#' 	The function checks if all items in a nested list are unique. If they are 
#' 	not, the function removes duplicates and issues a warning. In case there
#' 	are no duplicates, the function does nothing.
#' @return a list
#' 
#' @keywords internal

check_element = function(element) {

	# checking whether there are duplicate items 
	dup_name = sapply(
		element,
		function(x) any(duplicated(names(x)))
	)
	dup_name = names(dup_name)[dup_name]

	if (length(dup_name) > 0) {	
		# removing duplicates
		element[dup_name] = lapply(
			element[dup_name],
			function(x) {x[!duplicated(names(x))]}
		)

		# issuing warning to inform user
		warning(
			sprintf(
				"Items with identical names detected in: %s. ", 
				paste(dup_name, collapse = ", ")
			), 
			"Retaining only one item to avoid further problems.\n",
			"\tPlease modify the building file to avoid any ambiguity."
		)
	}

	# returning result without duplicates
	return(element)
}


