#' @title calculate walls width
#' 
#' @description
#' `calculate_wall_width_02()` and `calculate_wall_width_03()` are **internal**
#' functions that calculate  widths for walls.
#' 
#' Beware that walls sould be described in a data.frame with some expected
#' columns:
#' - `building` (only for `calculate_wall_width_03()`)
#' - `storey`
#' - `room`
#' - `x`
#' - `y`
#' 
#' The ‘correct order’ of the walls means that the order of the lines should
#' recreate the natural order in which the walls of a given room are arranged.
#' The `x` and `y` co-ordinates only give the starting point of a wall, the end
#' point of the wall is given by the co-ordinates of the next line.
#' 
#' @param wall data.frame of walls characteristics, supposed to be in a ‘correct
#' order’. See details.
#'
#' @return vector of walls widths
#' 
#' @examples
#' 
#' data_table = extract_building_information(adu_t)
#' 
#' # Lazy
#' floodam.building:::calculate_wall_width_02(data_table[["wall"]])
#' 
#' # Better
#' floodam.building:::calculate_wall_width_02(data_table[["wall"]][c("storey", "room", "x", "y")])
#' 
#' @keywords internal

calculate_wall_width_02 = function(wall) {
	fun = function(wall) {
		sqrt(
			(wall[["x"]] - c(wall[["x"]][-1], wall[["x"]][1]))^2 +
				(wall[["y"]] - c(wall[["y"]][-1], wall[["y"]][1]))^2
		)
	}
	
	unlist(lapply(split(wall, wall[c("storey", "room")]), fun))
}

#' @rdname calculate_wall_width_02
#'
#' @keywords internal

calculate_wall_width_03 = function(wall) {
	fun = function(wall) {
		sqrt(
			(wall[["x"]] - c(wall[["x"]][-1], wall[["x"]][1]))^2 +
				(wall[["y"]] - c(wall[["y"]][-1], wall[["y"]][1]))^2
		)
	}
	
	unlist(lapply(split(wall, wall[c("building", "storey", "room")]), fun))
}

# Deprecated. Should be removed if anything is fine.
# add_wall_width = function(wall) {
# 	fun = function(wall) {
# 		wall[["width"]] = sqrt(
# 			(wall[["x"]] - c(wall[["x"]][-1], wall[["x"]][1]))^2 + 
# 				(wall[["y"]] - c(wall[["y"]][-1], wall[["y"]][1]))^2
# 			)
# 		return(wall)
# 	}
	
# 	simplify2data_frame(lapply(split(wall, wall[c("storey", "room")]), fun))
# }

