#' Adjust model information in the table wall (version 2)
#' 
#' @param data_table list of table informations of the model.
#' @param building_height numeric, height pf the building
#' 
#' @return the wall table adjusted
#' 
#' @keywords internal
 
adjust_wall_02 = function(data_table, building_height) {
	# Preparing room and merging
	room = data_table[["room"]]
	room[["room_name"]] = room[["name"]]
	room = room[c("room", "room_name", "H_abs", "ceiling_H", "height_storey")]
	result = merge(data_table[["wall"]], room)
	
	# Adjusting H_abs
	selection = grep("^H$|^H_abs$", names(result))
	result[["H"]][is.na(result[["H"]])] = 0
	result[["H_abs"]] = apply(result[selection], 1, sum, na.rm = TRUE)

	# Adjusting height
	result[["height"]][is.na(result[["height"]])] = result[["ceiling_H"]][is.na(result[["height"]])] -
		result[["H"]][is.na(result[["height"]])]
	result[["height"]][is.na(result[["height"]])] = result[["height_storey"]][is.na(result[["height"]])] -
		result[["H"]][is.na(result[["height"]])]
	result[["height"]][is.na(result[["height"]])] = building_height -
		result[["H"]][is.na(result[["height"]])]
	result[["height_storey"]] = NULL
	
	#Calculating surface
	result[["surface"]] = result[["height"]] / 100 * result[["width"]]
	
	# Making elementary_component
	result[["wall_elementary_component"]] = compose_elementary_component(
		result[["wall_type"]],
		result[["material"]]
	)
	result[["render_elementary_component"]] = compose_elementary_component(
		"wall",
		result[["render"]],
		what = "render"
	)
	result[["insulating_elementary_component"]] = compose_elementary_component(
		result[["wall_type"]],
		result[["insulating"]],
		what = "insulating"
	)
	
	rownames(result) = result[["id_wall"]]
	invisible(result[order(result[["storey"]], result[["room"]], result[["order"]]), ])
}

#' Adjust model information in the table wall (version 3)
#' 
#' @param data_table list of table informations of the model.
#' 
#' @return the wall table adjusted
#' 
#' @keywords internal

adjust_wall_03 = function(data_table) {

	# Adding parameter information
	result = keep_df_order(
		data_table[["wall"]],
		merge,
		data_table[["parameter"]][["wall"]],
		all.x = TRUE,
		by = "type",
		suffixes = c("_x","_y")
	)

	# Preparing room and merging
	room = data_table[["room"]]
	room[["room_name"]] = room[["name"]]
	room = room[c("building", "storey", "room", "room_name", "H_abs", "ceiling_H", "height_storey")]
	result = keep_df_order(result, merge, room, suffixes = c("_x","_y"))
	
	# Adjusting H_abs
	selection = grep("^H$|^H_abs$", names(result))
	result[["H"]][is.na(result[["H"]])] = 0
	result[["H_abs"]] = apply(result[selection], 1, sum, na.rm = TRUE)

	# Adjusting height
	result[["height"]][selection] = result[["ceiling_H"]][is.na(result[["height"]])] -
		result[["H"]][is.na(result[["height"]])]
	result[["height"]][selection] = result[["height_storey"]][is.na(result[["height"]])] -
		result[["H"]][is.na(result[["height"]])]
	result[["height_storey"]] = NULL
	
	#Calculating width
	result[["width"]]  = calculate_wall_width_03(result[c("building", "storey", "room", "x", "y")])
	
	# Making elementary_component
	result[["wall_elementary_component"]] = compose_elementary_component(
		result[["wall_type"]],
		result[["material"]]
	)
	result[["render_elementary_component"]] = compose_elementary_component(
		"wall",
		result[["render"]],
		what = "render"
	)
	result[["insulating_elementary_component"]] = compose_elementary_component(
		result[["wall_type"]],
		result[["insulating"]],
		what = "insulating"
	)
	
	invisible(result)
}


	
