#' Add a given msg to a log file
#'
#' @param msg , principal part of the message to be added
#' @param x character, secondary part of the message, will be indented to look like a list. If length(x) is 0, nothing is added.
#' @param log, character the log file to update
#' @return NULL
#' @examples
#' \dontrun{
#' add_log("Some trouble occurs", c("bad resolution", "missing openings"), LOG)
#' }
#' 
#' @export

# add_log
# add a msg to log file

add_log = function(msg, x = NULL, log) {
	if (length(x) > 0)
	{
		msg = c(msg, paste("\t-", x))
		write(msg, log,  append = TRUE, sep = " ")
	}
}
