# floodam.building 1.7.6.0

Release date: 2025-10-27

## Enhancements

- `analyse_hydraulic()`
    - Remove verbose for merging rooms
- `compute_hydraulic()`
    - New output by level
    - Ceiling is now taken in account when filling rooms
    - Add a volume output (`vo`)
    - Rename flow speed from `v` to `vi`
- `find_room_to_merge()`  (internal)
    - Add verbose
- `merge_room()`  (internal)
    - Rework entirely code to handle different ceiling and floor height
- `plot.hydraulic()` 
    - New function to plot hydraulics by level
    - Room or opening selection allowed
- `plot_hydraulic()` (internal)
    - Used by `plot.hydraulic()`
- `plot_hydraulic_level()`  (internal)
    - Used by `plot_hydraulic()`
    - Plot hydraulics by level
    - Time format is changed from `s` to `h` for plotting

# floodam.building 1.7.5.0

Release date: 2025-10-27

## Enhancement

- `analyse_hydraulic()`
    - Changed error message about not enabling hydraulic in `analyse_model`, causing damaging to be missing
- `test_hydraulic_functionalities()`  (internal)
    - New test file aiming to tests all `analyse_hydraulic()` parameters

## Bugs

- `compute_hydraulic()`
    - Fixed matrices converted to one dimension vectors when there's only one room or opening
- `prepare_hydraulic_input()`
    - Fixed the management of opening collapse when `permeability` is set to `both`. Vertical opening are set to 0 while
    horizontal ones are set to open format.

# floodam.building 1.7.4.0

Release date: 2025-09-26

## Enhancements

- `analyse_hydraulic()`
    - Data frame `open` transfered to `compute_hydraulic()`
    - New parameter `height_break`, the height difference on each side of an
    opening needed to break it
- `compute_hydraulic()`
    - New parameter `open`
    - Checking water dpeth difference around openings to make them collapse if 
    the difference is too big
    - New parameter `height_break`, the height difference on each side of an
    opening needed to break it

# floodam.building 1.7.3.0

Release date: 2025-09-05

## Enhancements

- `adjust_h_abs()`(internal)
    - New function to adjust absolute height with different options (`model`,
    `room`, `component`). `model` is the expected behaviour at model level,
    `room` is to be used for calculation of autonomous damage functions at room level.
- `adjust_opening_02()`(internal)
    - add a column with `id_wall` to the data.frame `opening` in the slot
    `data_table` of model
- `analyse_model()`
    - parameter `dam_by_room` removed
    - calculation of damage by room added to stage `hydraulic`
    - New extended documentation
- `analyse_hydraulic()`
    - Includes changes in `get_hydraulic_change()`
    - New parameters inherited from function `get_hydraulic_damage()`
    - New parameter `permeability` manage how the water can flow for closed
    opening. Results are unchanged, in particular the slot `eQ` for
    `permeability = "both"` is the sum of the flows for the 2 types of openings
    created to simulate the path of water.
- `compute_damage()`
    - Restructuration of internal code to enhance modularity
- `compute_damage_by_room_wall()`
    - New function added to handle the calculation of damage estimations by 
    room and external wall segment
- `compute_damage_detail()` (internal)
    - New parameter`h_abs` that allows a call to `adjust_h_abs()` before any 
    other calculation
- `compute_damage_from_detail()` (internal)
    - New function added to handle consistently damage computing at different
    levels in `compute_damage()`
- `compute_hydraulic()`
    - Changed how the hmax mean is calculated to only account for inside
- `extract_damage_detail_by_room()` 
    - Call to `extract_damage_detail_external()` removed
- `extract_damage_detail_external()` 
    - Now exported (internal up until version 1.7.2.0)
    - Function rewritten using `apply()` family functions instead of `for` loops
- `extract_hydraulic_input()`
    - New parameter `permeability` to manage how the water can flow for closed
    opening. `bottom` creates small opening, `vertical` creates narrow openings,
    `both` creates both type.
- `extract_wall()`
    - add of `id_wall`, an unique ID for each wall present in the model
- `find_room_to_merge()`
    - Management of exterior invisible wall, they should not lead to any merge.
    Useful for buried walls, especially in basements.
- `generate_limnigraph()`
    - New parameter `model`, allows to check validity of given data
    - Walls not given by the user for the limnigraph are now set to 0
    - Adaptation to multi-storey dwelling
- `get_hydraulic_damage()`
    - changed the way damages are evaluated after the hydraulic simulation. Used
    to be rounded to closest decimeter and is now using interpolation
    - added threshold to ignore damages when water height is lower than 1cm
    - Adaptation to multi-storey dwelling
- `load_furniture()`
    - to ensure consistency with the other components, the variables `room`,
    `wall` and `H` (constructed from `wall_name`, `room_name` and
    `relative_height` respectively) are added to result
- `prepare_hydraulic_input()`
    - Adaptation to multi-storey dwelling
- `stage()` (internal)
    - automatic generation of message and write to file_log
- `sumup_damaging()`
    - Processing adapted to the case where x is a list of NULL values (can
    happen with a completely buried basement, for instance in `adu_t_basement`)

## Documentation

- `generate_limnigraph()`
    - More detailed documentation on how to create limnigraphs and how to handle
    facade and externals

## Data

- `adu_t`, `adu_t_basement`, `adu_t_levels`, `adu_t_missing`
    - furniture updated
- `adu_t_basement`
    - bugs in furniture removed
- `adu_t`
    - damage functions by room available in preloaded model

# floodam.building 1.7.2.0

Release date: 2025-05-16

## Enhancements

- `adjust_elementary_damaging()`
    - `cat()` substituted by `message()`
- `analyse_hydraulic()`
    - tests improved
- `calculate_surface_height()`
    - `cat()` substituted by `message()`
- `check_floodam()`
    - `cat()` substituted by `message()`
- `compute_damage_detail()`
    - `cat()` substituted by `message()`
- `declinaison_building()`
    - `cat()` substituted by `message()`
- `extract_building_information()`
    - `cat()` substituted by `message()`
- `extract_hydraulic_input()`
    - `cat()` substituted by `message()`
- `extract_value()`
    - `cat()` substituted by `message()`
- `inspect_building()`
    - `cat()` substituted by `message()`
- `load_model()`
    - `cat()` substituted by `message()`
- `produce_elementary_damaging()`
    - `cat()` substituted by `message()`
- `save_model()`
    - `cat()` substituted by `message()`
- `update_ape()`
    - function `rio::export()` substituted by function `writexl::write_xlsx()`
- `update_ape_damaging()`
    - `cat()` substituted by `message()`
- `update_category_damaging()`
    - `cat()` substituted by `message()`
- `update_esane_from_tar()`
    - `cat()` substituted by `message()`
- `update_legend()`
    - `cat()` substituted by `message()`
- `update_type()`
    - `cat()` substituted by `message()`
- `plot_vertical_surface()` (internal)
    - New name for `plot.vertical_surface()` as the function is not intended to
    be a S3 method (no object of class `vertical_surface` exists)
- `plot_efficiency()` (internal)
    - New name for `plot.efficiency()` as the function is not intended to
    be a S3 method (no object of class `efficiency` exists)
- `plot_esane()` (internal)
    - New name for `plot.esane()` as the function is not intended to
    be a S3 method (no object of class `esane` exists)

# floodam.building 1.7.1.0

Release date: 2025-05-16

## Enhancement

- `analyse_hydraulic()`
    - New parameter `clearance` handling the distance between an opening and
    its frame (in centimeters). It represents water tightness for the opening
    - Documentation updated

## Documentation

- `plot_hydraulic()`
    - Explanations and examples added

# floodam.building 1.7.0.0

Release date: 2025-05-07

## Enhancements

- `analyse_model()`
    - No longer returns the slot *detail_by_room* when parameter 
    `dam_by_room` is `TRUE` to avoid redundancy with slot `detail`
- `analyse_hydraulic()`
    - New parameter `stages` to ensure the consistency with `analyse_model()` 
    function
    - New parameter `detail` to choose between detailed outputs or synthetic
    ones (only hmax and damage) from simulations. `detail=FALSE` makes
    simulations lighter to save when running a lot of them.
    - Renamed scenario `combined` to `combine` to ensure better consistency with
     other scenarios.
- `compute_hydraulic()`
    - Restructuration of some functions to enhance handling of invisible walls 
- `find_room_to_merge()`, `merge_room()` and `split_output()` (internal)
    - New functions added to handle invisible walls during the hydraulic
    simulation
    - It also handles cases where rooms separated by invisible walls a different
    elevation
- `plot.elementary_damaging()`
    - Function transformed in S3 method to provide a basic displays for objects
    of class `elementary_damaging`
- `plot.hydraulic()`
    - New S3 method to provide a basic displays for object of class `hydraulic`
    - By default displays water height but `view` can be set to `discharge`, can
    also render `pdf` and `png`
- `plot_analysis_damaging()` (internal)
    - New name for `plot.analysis_damaging()` as the function is not intended to
    be a S3 method (no object of class `analysis_damaging` exists)
- `plot_relative_damaging()` (internal)
    - New name for `plot.relative_damaging()` as the function is not intended to
    be a S3 method (no object of class `relative_damaging` exists)
- `prepare_hydraulic_input()`, `extract_hydraulic_input()`
    - Ensuring good handling of invisible walls
    - Ensuring good handling of levels variations between rooms
- `get_hydraulic_damage()`   
    - New function to be able to compute a more precise damage output based on
    the hydraulic simulation
    - Preventing water level to be below 0 and above 5m
- `generate_limnigraph()` 
    - Externals are now groups of walls
- `compute_danger()`
    - New function to compute the danger when opening a door
- `compute_damage()`
    - Behavior of the function when `dam_by_room` is `TRUE` has been modified.
    `distrib_by_room()` (internal) has been replaced by
    `extract_damage_detail_by_room()`,
    `extract_elementary_component_from_detail()`, and
    `extract_damage_detail_external()`.
- `extract_damage_detail_by_room()`
    - New function to extract elementary damages by room
- `extract_elementary_component_from_detail()`
    - New function to extract elementary damages by categories of elementary components (floor,
    ceiling, wall, opening, coating and furniture)
- `extract_damage_detail_external()` (internal)
    - New function to extract elementary damages in the external by wall.

## Data

- `BUILDING` 
    - Template updated (tag *side* removed)    
    - Models using tag *side* no longer supported
- `adu_elevator`, `adu_l`, `adu_t_2room`, `adu_t_basement`, `adu_t_invisible`,
`adu_t`
    - Models adapted to be consistent with the new `BUILDING` template  
- `adu_t_basement`
    - Model improved and bugs removed
- `adu_l`
    - Correction on door names

## Documentation

- article `adu_t_single-storey`
    - Integration of changes in model `adu_t`
- article `adu_t_two-storey`
    - Integration of changes in model `adu_t_basement`
- article `Input file for a n-storey building`
    - Integration of changes in model `adu_t_basement`

# floodam.building 1.6.7.1

Release date: 2025-04-04

## Data

- `adu_l`
    - Correction of building file (missing names for openings added, needed for
    hydraulic module)

# floodam.building 1.6.7.0

Release date: 2025-04-04

## Enhancements

- `check_element()` (internal)
    - New function to check if items with the same name have been declared in
    the *element* block of the *building* input file
    - If *elements* with the same name are found, the function keeps only the
    first *element* and throws a warning
    - documentation and test added
- `adjust_opening()` (internal)
    - Warning and error messages modified

## Data

- adu_component_repeated
    - New model added to test function `check_element()`

# floodam.building 1.6.6.0

Release date: 2025-02-24

## Data

- inst/extdata/model/component_elementary:
    - Changes for 'category_vulnerability.csv', 'component_elementary_action.csv',
    'component_elementary.csv'
- `DAM`, `COMPONENT_ELEMENTARY`:
    - Change in name for 
        - "baseboard_pvc"
        - "door_exterior_pvc"
        - "door_garage_overhead_pvc"
        - "drainage_network_pvc"
        - "french_window_pvc"
        - "french_window_shutter_louvered_pvc"
        - "french_window_shutter_rolling_pvc"
        - "french_window_shutter_solid_pvc"
        - "window_pvc"
        - "window_shutter_louvered_pvc"
        - "window_shutter_rolling_pvc"
        - "window_shutter_solid_pvc"
        - "wall_render_exterior_lime_nhl_3_5"
    - **IMPLY ADAPTATIONS FOR MODEL (building part)**
- `adu_elevator`, `adu_l`, `adu_t_2room`, `adu_t_basement`, `adu_t_invisible`,
`adu_t`
    - Change in material ("PVC" to "pvc")

# floodam.building 1.6.5.0

Release date: 2025-02-23

## Data

- `adu_t_basement`
    - New preloaded model with stage `load` only
- `adu_elevator`
    - New preloaded model with stage `load` only
- `adu_t_2room`
    - New preloaded model with stage `load` only
- `adu_t_invisible`
    - New preloaded model with stage `load` only
- `adu_l`
    - New preloaded model with stage `load` only


# floodam.building 1.6.4.0 

Release date: 2025-02-23

## Enhancements

- `calculate_wall_width_02()` (internal)
    - replace `add_wall_width()`
    - documentation and test added
- `calculate_wall_width_03()` (internal)
    - replace `calculate_wall_width()`
- `extract_wall()`(internal)
    - adapted to `calculate_wall_width_02()`
    - documentation added

## Data

- `adu_t`
    - Preloaded model with stage `load`, `extract`, `damaging`, and `hydraulic`
    to help tests

# floodam.building 1.6.3.0 

Release date: 2025-02-21

## Data

- `adu_t`
    - Preloaded model *dwelling* renamed as *adu_t*

## Documentation

- `adu_t`
    - Documentation modified
- Keyword *internal* added to documentation of internal functions
- Vignettes on model creation (from plan to input files) converted to articles
- Release dates added to changelog

# floodam.building 1.6.2.0 

Release date: 2025-02-20

## Enhancements

- `prepare_elevator_data()` (internal)
    - New function to handle the integration of the new elevator elementary
    components
- `update_elementary_damaging()` (internal)
    - code block added to integrate elevator components in `DAM`
- `DAM`
    - New elementary damaging functions for elevator components
- `COMPONENT_ELEMENTARY`
    - New elementary components for elevator

## Data

- New model available in inst/extdata/model/adu/adu_elevator:
    - *adu_elevator* is a 3-storey building with one room and one elevator shaft
    per storey
- New internal datasets available in inst/extdata/component_elementary/elevator:
    - elevator_vulnerability.csv
    - elevator_complementary.csv

## Documentation

- New vignette available
    - *how to add an elevator to your model* 

# floodam.building 1.6.1.0

Release date: 2025-01-29

## Enhancements

- `compute_exchange()` (internal)
    - No need for `opening_name` as an input, it is deducted from `colnames(exchange)`.
    If `colnames(exchange)` is `NULL`, it should work as expected.
    - documentation and tests are improved.

# floodam.building 1.6.0.1

Release date: 2025-01-25

## Bugs 

- Several bugs in documentation solved

# floodam.building 1.6.0.0

Release date: 2025-01-21

In this version of the library, the hydraulic module has been rewritten entirely 
in R and Rcpp. The goal is to enhance the coherence of the code and make it more
flexible for futur updates. All python dependencies have been removed. 

## Enhancements

- `analyse_hydraulic()` 
    - New function that sets up new hydraulic module written in R
- `compute_hydraulic()` (internal)
    - New hydraulic module written in R, faster and more optimised than the 
    previous Python hydraulic module. 
- `compute_exchange()` (internal)
    - New function allowing flow rate computations written in pure R.
- `rcpp_compute_exchange()` (internal)
    - New function allowing flow rate computations written in Rcpp. It has a 
    faster running time than it's R counter part `compute_exchange()`.
- `generate_limnigraph()` 
    - The limnigraph now has to be ordered by externals, and the externals have 
    to be specified.
- `update_path()`
    - `model_output_hydraulic` added to save hydraulic outputs.
- dependency of `reticulate` library removed
- function `manage_python()` removed
- module `hydraulic_module.py` removed
- function `analyse_hydraulics()` removed
- function `.onAttach()` removed
- package global variable *floodam_building_py* removed
- Test *is_compatible_python* removed

# floodam.building 1.5.0.3

Release date: 2025-01-16

## Bugs 

- `order_wall()` (internal)
    - Could not deal external with many walls (more than 26). Now it can. Start the 27th to AA and so
    on up to ZZ. Model can have external with 702 walls now.
- `compute_damage_detail()` (internal)
    - Information on room and storey were discarded for ceiling before being passed to adjust_dam_by_component. And so
    `distrib_by_room()` could not affect ceiling components to the good room.

# floodam.building 1.5.0.2

Release date: 2024-11-20

## Bugs 

- `is_compatible_python()` (internal)
    - Really solved bug provoking error when loading the library
    (coming from change in R version 4.4 and management of `x < 3` when x is a
    character)
    - test added
    
# floodam.building 1.5.0.1

Release date: 2024-11-19

## Bugs 

- `is_compatible_python()` (internal)
    - new name for `compatible_python()`
    - Solved bug provoking error when loading the library

# floodam.building 1.5.0.0

Release date: 2024-11-04

## Enhancements
- `adjust_elementary_damaging()`
    - `stop()` sequence when checking parameter *damaging* removed. Now the
    function returns NULL if parameter *damaging* is NULL, allowing the estimate
    of the building's damage function ignoring missing elementary components
- `compute_damage()`
    - use of `message()` instead of `cat()` for `verbose` or `talkative` mode
    - new management of missing elementary component:
        - if some elementary components ar missing (i.e. are not present in
        `DAM`), then `compute_damage()` does not return NULL. It continues the
        calculation, consistent with  new behavior of
        `adjust_elementary_damaging()`.
        - a message and a warning are sent to inform the user that the
        estimation will be done ignoring those elementary components.
- `check_damaging()`
    - Modified warning message, consistent with new behavior of
    `adjust_elementary_damaging()`
    - Modified log message, consistent with new behavior of
    `adjust_elementary_damaging()`
    - variable *missing* renamed to *missing_component* to avoid confusion with
    the `base::missing()` function
- `load_model()`
    - no use of `options(warn)` to be better tested with
    `testthat::expect_warning()`
- `order_wall()`
    - no use of `options(warn)` to be better tested with
    `testthat::expect_warning()`
- `to_numeric()` (internal)
    - extracted from `loead_model()`, to deal with 'clever' transformation from
    character to numeric
    - test added
- `remove_comment()` (internal)
    - extracted from `loead_model()`, to deal with removal of comments when
    reading xml files
    - test to be added

## Data

- New model available in inst/extdata:
    - *adu_t_missing* is similar to *adu_t* with missing elementary components

# floodam.building 1.4.1.0

Release date: 2024-10-28

## Data

- New model *dwelling* available as package data
- New model available in inst/extdata:
    - *adu_t_bassement* is two storey dwelling composed of a single-room
    basement and a 4-room ground floor (3 rooms around a central room)
- Furniture included in models *adu_t* and *adu_t_basement*

## Documentation

- New vignette explaining how to model +1 storey buildings
- New vignette explaining how to handle furniture
- Update of function examples

## Bugs 

- `analyse_hydraulics()`
    - Solved bug provoking error when function called

# floodam.building 1.4.0.2

Release date: 2024-10-04

## Bugs

- `load_model()`
    - keep only one category of elementary components when too many are found
    and generate a warning
- `COMPONENT_ELEMENTARY`
    - keep only one category for activities' elementary components
- `analyse_hydraulics()`
    - adapt to reticulate's strange way of calling attribute

# floodam.building 1.4.0.1

Release date: 2024-09-13

## Enhancements
- `create_new_model()`
    - New *metadata* value for the input_file parameter to generate, from an
    internal template, the metadata file to be inputted

## Documentation

- Update and bug handling of function examples

# floodam.building 1.4.0.0

Release date: 2024-06-19

## Enhancements

- COMPONENT_ELEMENTARY
    - Elementary vulnerability function categories in variable
    `category_vulnerability` deduplicated and relabeled

# floodam.building 1.3.2.0

Release date: 2024-05-15

## Enhancements

- `analyse_hydraulics()`
    - The function now executes the hydraulic module of floodam.building in
    either the default python virtual environment "floodam" or in a user-defined
    python virtual environment, provided using the new parameter `envname`.
- `manage_python()`
    - Function to manage the installation of python dependencies needed by the
    hydraulic module of floodam.building. It creates a virtual environment to
    avoid system pollution or dependency conflicts.
- `compatible_python()` (internal)
    - Internal function that checks whether Python 3 is installed
- `py_simulate_hydraulics()` (internal)
    - replace `sim_hydrau_py()`
    - execute the hydraulic module of floodam.building in either the default
    python virtual environment, "floodam", or in a user-defined python virtual
    environment, provided using the new parameter `envname`. 
- `plot.damaging()`
    * Finalization of snake_case transformation for internal functions.
- `plot.model()`
    * Finalization of snake_case transformation for internal functions.

## Documentation

- Cover page of website
    - Modification of installation instructions

# floodam.building 1.3.1.1

Release date: 2024-04-28

## Bugs

- `compute_damage()`
    - Solved bug provoking error when function called from function
    apply_measure()
- `create_new_model()`
    - export added

# floodam.building 1.3.1.0

Release date: 2024-04-09

## Enhancements

- `create_new_model()`
    - Function to generate template for new model

## Documentation

- Vignettes 
    - *The structure of the input file of floodam.building*
    - *From the architect's plan to the input file of floodam.building*

## Dependencies 

- R
    - Package `DT`
    - Package `htmltools`

# floodam.building 1.3.0.0

Release date: 2023-10-25

## Enhancements

- `analyse_hydraulics()`
    - Function to simulate the hydraulics in the interior of the building
- `analyse_model()`
    - New stage "hydraulic"
- `extract_hydraulic_input()`
    - Function called by `analyse_model()` to generate input on exchanges
    through openings
    - Called when "hydraulic" is given as `stage`
- `generate_limnigraph()`
    - Function to generate limnigraph (evolution of water depth against time)
- New global variables (input needed by hydraulic simulator)
    - `floodam_building_hydraulic_discharge_coefficient`, default value 0.42
    - `floodam_building_hydraulic_initial_water_depth_interior` default value 0
    - `floodam_building_hydraulic_closed_opening_clearance` default value 0.5
- New optional tags in XML input to facilitate the identification of water
    exchanges through openings and *empty* walls
    - opening names
    - wall names

## Data

- dwelling models in inst/extdata:
    - *adu_l* is a single storey linear 4-room dwelling
    - *adu_t* is a single storey 4-room dwelling; 3 rooms around a central room
    - *adu_t_2room* is a single storey 2-room dwelling; created by merging rooms
    in *adu_t*
    - *adu_t_invisible* is similar to *adu_t_2room* but instead of merged, rooms
    are separated by invisible walls

## Documentation

- Vignettes 
    - *Getting started with floodam.building*
    - *Simulating the hydraulic behavior of the interior of a building
    (English)*

- *How to install python dependencies*

## Dependencies 

- R
    - Package `reticulate`
- Python
    - Python 3
    - Package `NumPy`
    - Package `pandas`
